// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./audio_wave.css.js";import{getHtml}from"./audio_wave.html.js";export const blurredRectUrl="//resources/cr_components/search/images/eclipse_wave_blurred_rect.png";const BEZIER_TENSION_RATIO=.38;const MAX_AMPLITUDE=-25;const MIN_AMPLITUDE=-0;const MAX_VERTICAL_SHIFT=-10;const MIN_VERTICAL_SHIFT=-0;const WAVE_SIDE_MARGIN_IDLE=56;const WAVE_SIDE_MARGIN_PEAK=10;const STROKE_WIDTH=3;const MS_PER_FRAME=16.67;const CIRCLE_RAD=Math.PI*2;const MIN_FRAMES_PER_SYLLABLE=6;const MAX_FRAMES_PER_SYLLABLE=8;const FRAME_LATENCY=-12;const SMOOTHING_WINDOW_SIZE=3;const SMOOTHING_BUFFER_SIZE=5;function clamp(value,minVal,maxVal){return Math.min(Math.max(value,minVal),maxVal)}function mapToRange(value,inputMin,inputMax,outputMin,outputMax,shouldClamp=false){if(shouldClamp){value=clamp(value,inputMin,inputMax)}return(value-inputMin)*((outputMax-outputMin)/(inputMax-inputMin))+outputMin}function countSyllablesHeuristic(word){word=word.toLocaleLowerCase();if(word.length===0){return 0}if(word.length<=3){return 1}word=word.replace(/(?:[^laeiouy]es|(?<=[^td])ed|[^laeiouy]e)$/,"");word=word.replace(/^y/,"");const vowelGroups=word.match(/[aeiouy]{1,2}/g);return vowelGroups?vowelGroups.length:1}function weightedAverage(numArray,amountToAverage){let weightedSum=0;let sumOfWeights=0;for(let i=0;i<amountToAverage;i++){const weight=amountToAverage-i;weightedSum+=(numArray[i]??0)*weight;sumOfWeights+=weight}return sumOfWeights===0?0:weightedSum/sumOfWeights}function bezierEasing(controlX1,controlX2,timeProgress){if(timeProgress<=0){return 0}if(timeProgress>=1){return 1}if(controlX1===0&&controlX2===1){return timeProgress}let currentT=timeProgress;const coeffA=3*controlX1;const coeffB=3*(controlX2-controlX1)-coeffA;const coeffC=1-coeffA-coeffB;for(let i=0;i<8;i++){const currentX=((coeffC*currentT+coeffB)*currentT+coeffA)*currentT;if(Math.abs(currentX-timeProgress)<1e-6){break}const currentSlope=(3*coeffC*currentT+2*coeffB)*currentT+coeffA;if(Math.abs(currentSlope)<1e-6){break}currentT-=(currentX-timeProgress)/currentSlope}return 3*currentT*currentT-2*currentT*currentT*currentT}export class AudioWaveElement extends CrLitElement{static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{isListening:{reflect:true,type:Boolean},isExpanding_:{reflect:true,type:Boolean},transcript:{type:String},receivedSpeech:{type:Boolean}}}#isListening_accessor_storage=false;get isListening(){return this.#isListening_accessor_storage}set isListening(value){this.#isListening_accessor_storage=value}#transcript_accessor_storage="";get transcript(){return this.#transcript_accessor_storage}set transcript(value){this.#transcript_accessor_storage=value}#receivedSpeech_accessor_storage=false;get receivedSpeech(){return this.#receivedSpeech_accessor_storage}set receivedSpeech(value){this.#receivedSpeech_accessor_storage=value}#isExpanding__accessor_storage=true;get isExpanding_(){return this.#isExpanding__accessor_storage}set isExpanding_(value){this.#isExpanding__accessor_storage=value}containerWidth_=0;animationFrameId_=null;decayingAmplitude_=0;frame_=0;lastUpdateTime_=performance.now();lastWordCount_=0;volumeHistory_=[];activeSimulatedBumps_=[];firstSyllable_=true;resizeObserver=new ResizeObserver((entries=>{for(const entry of entries){this.containerWidth_=entry.contentRect.width}}));connectedCallback(){super.connectedCallback();if(this.$.eclipseSvg){this.resizeObserver.observe(this.$.eclipseSvg)}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("isListening")){this.isListening?this.onStartListen():this.onStopListen();this.receivedSpeech=false}if(changedProperties.has("transcript")){this.handleNewWords()}if(changedProperties.has("receivedSpeech")){if(this.receivedSpeech){this.decayingAmplitude_=.4;for(let i=0;i<this.volumeHistory_.length;i++){this.volumeHistory_[i]=Math.max(this.volumeHistory_[i]??0,.3)}this.makeSimulatedAudioBump(15,25,this.frame_,.14,.05);if(this.transcript===""){this.firstSyllable_=false}}}}disconnectedCallback(){super.disconnectedCallback();this.onStopListen();this.resizeObserver.disconnect()}onStartListen(){this.isExpanding_=true;this.volumeHistory_=new Array(SMOOTHING_BUFFER_SIZE).fill(.001);if(this.animationFrameId_===null){this.animationFrameId_=requestAnimationFrame(this.processFrame)}}onStopListen(){this.frame_=0;this.decayingAmplitude_=0;if(this.animationFrameId_!==null){cancelAnimationFrame(this.animationFrameId_);this.animationFrameId_=null}this.isExpanding_=false}processFrame=()=>{if(!this.isListening){this.animationFrameId_=null;return}const now=performance.now();const elapsed=now-this.lastUpdateTime_;if(elapsed>MS_PER_FRAME){this.updateVolume();let level=this.volumeHistory_[0];if(SMOOTHING_WINDOW_SIZE>0){level=weightedAverage(this.volumeHistory_,SMOOTHING_WINDOW_SIZE)}level=bezierEasing(.4,.6,level??0);this.drawEclipseWavePath(level);this.lastUpdateTime_=now-elapsed%MS_PER_FRAME}if(this.isListening){this.animationFrameId_=requestAnimationFrame(this.processFrame)}};drawEclipseWavePath(rawInputLevel){this.frame_++;this.decayingAmplitude_=Math.max(this.decayingAmplitude_,rawInputLevel);this.decayingAmplitude_*=.85;const currentSidePadding=mapToRange(Math.pow(this.decayingAmplitude_,2.5),0,1,WAVE_SIDE_MARGIN_IDLE,WAVE_SIDE_MARGIN_PEAK);const anchorLeftX=currentSidePadding;const anchorRightX=this.containerWidth_-currentSidePadding;const waveCenterX=(anchorLeftX+anchorRightX)/2;const waveHalfWidth=(anchorRightX-anchorLeftX)/2;const getParabolicDepth=xPosition=>{if(waveHalfWidth===0){return 0}const normalizedX=(xPosition-waveCenterX)/waveHalfWidth;const audioDisplacement=mapToRange(this.decayingAmplitude_,0,1,MIN_AMPLITUDE,MAX_AMPLITUDE);const baseOffset=mapToRange(this.decayingAmplitude_,0,1,MIN_VERTICAL_SHIFT,MAX_VERTICAL_SHIFT);return audioDisplacement*(1-Math.pow(normalizedX,2))+baseOffset};const controlPointXLeft=this.containerWidth_*BEZIER_TENSION_RATIO;const controlPointXRight=this.containerWidth_*(1-BEZIER_TENSION_RATIO);const controlPointY=getParabolicDepth(controlPointXLeft);const maskTranslateY=mapToRange(this.decayingAmplitude_,0,1,MIN_VERTICAL_SHIFT,MAX_VERTICAL_SHIFT);const buildBezierPath=(thickness,isSolidLine)=>{const topY=thickness*-.5+controlPointY;const bottomY=thickness*.5+(isSolidLine?controlPointY:-controlPointY);return`M ${anchorLeftX},${0}\n                  C ${controlPointXLeft},${topY} ${controlPointXRight},${topY} ${anchorRightX},${0}\n                  C ${controlPointXRight},${bottomY} ${controlPointXLeft},${bottomY} ${anchorLeftX},${0}\n                  Z`};this.$.thinPath.setAttribute("d",buildBezierPath(STROKE_WIDTH,true));this.$.lowerGlowPath.setAttribute("d",buildBezierPath(STROKE_WIDTH,false));const currentTransform=`translate(0, ${maskTranslateY})`;this.$.mask.setAttribute("transform",currentTransform);this.$.thinPath.setAttribute("transform",currentTransform);this.$.lowerGlowPath.setAttribute("transform",currentTransform);this.$.clipPathShape.setAttribute("transform",currentTransform);const bottomClipY=1e3;const topControlY=STROKE_WIDTH*-.5+controlPointY;const clipPathString=`M ${0},${-maskTranslateY*.25}\n    L ${anchorLeftX},${0}\n    C ${controlPointXLeft},${topControlY} ${controlPointXRight},${topControlY} ${anchorRightX},${0}\n    L ${this.containerWidth_},${-maskTranslateY*.25}\n    L ${this.containerWidth_},${bottomClipY}\n    L ${0},${bottomClipY}\n    Z`;this.$.clipPathShape.setAttribute("d",clipPathString)}updateVolume(){const startRamp=Math.min(1,this.frame_/40);let ambientSimulatedMotion=.01+(1+Math.cos(this.frame_/60*CIRCLE_RAD))*.05;ambientSimulatedMotion*=.25+(1+Math.cos((this.frame_+100)/400*CIRCLE_RAD))*.2*startRamp;ambientSimulatedMotion+=.01*Math.random();ambientSimulatedMotion*=startRamp;this.volumeHistory_.unshift(ambientSimulatedMotion+this.getSimulatedAudioBumpsSum());if(this.volumeHistory_.length>SMOOTHING_BUFFER_SIZE){this.volumeHistory_.length=SMOOTHING_BUFFER_SIZE}}handleNewWords(){const trimmedTranscript=this.transcript.trim();if(trimmedTranscript===""){this.lastWordCount_=0;return}const words=trimmedTranscript.split(/\s+/);const currentWordCount=words.length;if(currentWordCount<=this.lastWordCount_){this.lastWordCount_=currentWordCount;return}const newWordCount=currentWordCount-this.lastWordCount_;const newWords=words.slice(-newWordCount);this.lastWordCount_=currentWordCount;this.triggerSyllableBumps(newWords)}triggerSyllableBumps(words){let frameOffset=FRAME_LATENCY;words.forEach((word=>{const syllableCount=countSyllablesHeuristic(word);for(let i=0;i<syllableCount;i++){if(!this.firstSyllable_){this.makeSimulatedAudioBump(25,15,this.frame_+frameOffset,.12,.08);frameOffset+=MIN_FRAMES_PER_SYLLABLE+(MAX_FRAMES_PER_SYLLABLE-MIN_FRAMES_PER_SYLLABLE)*Math.random()}else{this.firstSyllable_=false}}frameOffset+=2}))}makeSimulatedAudioBump(durationMultiplier,durationOffset,startTime,maxVolMultiplier,maxVolOffset){this.activeSimulatedBumps_.push({duration:Math.random()*durationMultiplier+durationOffset,startTime:startTime,maxVol:maxVolOffset+Math.random()*maxVolMultiplier})}getSimulatedAudioBumpsSum(){let simulatedVolumeSum=0;let writeIndex=0;for(let i=0;i<this.activeSimulatedBumps_.length;i++){const bump=this.activeSimulatedBumps_[i];const bumpRelativeTime=this.frame_-bump.startTime;const progress=bumpRelativeTime/bump.duration;if(progress>=1){continue}if(this.frame_>=bump.startTime){let newBumpAddition=(1-(1+Math.cos(progress*CIRCLE_RAD))*.5)*bump.maxVol;newBumpAddition=clamp(newBumpAddition,0,1);simulatedVolumeSum+=newBumpAddition}this.activeSimulatedBumps_[writeIndex]=bump;writeIndex++}this.activeSimulatedBumps_.length=writeIndex;return simulatedVolumeSum}}customElements.define("audio-wave",AudioWaveElement);