// ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const AnswerStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum AnswerStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 7,
  kUnspecified = 0,
  kLoading = 1,
  kSuccess = 2,
  kUnanswerable = 3,
  kModelUnavailable = 4,
  kExecutionFailure = 5,
  kExecutionCanceled = 6,
  kFiltered = 7,
}

export const UserFeedbackSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserFeedback {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUserFeedbackUnspecified = 0,
  kUserFeedbackNegative = 1,
  kUserFeedbackPositive = 2,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_embeddings.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  setPage(page: PageRemote): void;
  search(query: SearchQuery): void;
  sendQualityLog(selectedIndices: number[], numEnteredChars: number): void;
  recordSearchResultsMetrics(nonEmptyResults: boolean, userClickedResult: boolean, answerShown: boolean, answerCitationClicked: boolean, otherHistoryResultClicked: boolean, queryWordCount: number): void;
  setUserFeedback(feedback: UserFeedback): void;
  maybeShowFeaturePromo(): void;
  openSettingsPage(): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setPage(
      page: PageRemote): void {
    this.proxy.sendMessage(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  search(
      query: SearchQuery): void {
    this.proxy.sendMessage(
        1,
        PageHandler_Search_ParamsSpec.$,
        null,
        [
          query
        ],
        false);
  }

  sendQualityLog(
      selectedIndices: number[],
      numEnteredChars: number): void {
    this.proxy.sendMessage(
        2,
        PageHandler_SendQualityLog_ParamsSpec.$,
        null,
        [
          selectedIndices,
          numEnteredChars
        ],
        false);
  }

  recordSearchResultsMetrics(
      nonEmptyResults: boolean,
      userClickedResult: boolean,
      answerShown: boolean,
      answerCitationClicked: boolean,
      otherHistoryResultClicked: boolean,
      queryWordCount: number): void {
    this.proxy.sendMessage(
        3,
        PageHandler_RecordSearchResultsMetrics_ParamsSpec.$,
        null,
        [
          nonEmptyResults,
          userClickedResult,
          answerShown,
          answerCitationClicked,
          otherHistoryResultClicked,
          queryWordCount
        ],
        false);
  }

  setUserFeedback(
      feedback: UserFeedback): void {
    this.proxy.sendMessage(
        4,
        PageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        [
          feedback
        ],
        false);
  }

  maybeShowFeaturePromo(): void {
    this.proxy.sendMessage(
        5,
        PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openSettingsPage(): void {
    this.proxy.sendMessage(
        6,
        PageHandler_OpenSettingsPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        impl.setPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_Search_ParamsSpec.$,
        null,
        impl.search.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_SendQualityLog_ParamsSpec.$,
        null,
        impl.sendQualityLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_RecordSearchResultsMetrics_ParamsSpec.$,
        null,
        impl.recordSearchResultsMetrics.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        impl.setUserFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
        null,
        impl.maybeShowFeaturePromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_OpenSettingsPage_ParamsSpec.$,
        null,
        impl.openSettingsPage.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "history_embeddings.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  search: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  sendQualityLog: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordSearchResultsMetrics: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maybeShowFeaturePromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openSettingsPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        this.setPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.search =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_Search_ParamsSpec.$,
        null,
        this.search.createReceiverHandler(false /* expectsResponse */),
        false);
    this.sendQualityLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_SendQualityLog_ParamsSpec.$,
        null,
        this.sendQualityLog.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordSearchResultsMetrics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_RecordSearchResultsMetrics_ParamsSpec.$,
        null,
        this.recordSearchResultsMetrics.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setUserFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_SetUserFeedback_ParamsSpec.$,
        null,
        this.setUserFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.maybeShowFeaturePromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
        null,
        this.maybeShowFeaturePromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openSettingsPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_OpenSettingsPage_ParamsSpec.$,
        null,
        this.openSettingsPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_embeddings.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  searchResultChanged(result: SearchResult): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  searchResultChanged(
      result: SearchResult): void {
    this.proxy.sendMessage(
        0,
        Page_SearchResultChanged_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_SearchResultChanged_ParamsSpec.$,
        null,
        impl.searchResultChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "history_embeddings.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  searchResultChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.searchResultChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_SearchResultChanged_ParamsSpec.$,
        null,
        this.searchResultChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AnswerDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SearchResultItemSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SearchQuerySpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const SearchResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_Search_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SendQualityLog_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordSearchResultsMetrics_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetUserFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_MaybeShowFeaturePromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenSettingsPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SearchResultChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AnswerDataMojoType {
  answerTextDirectives: string[];
}


export type AnswerData = AnswerDataMojoType;
mojo.internal.Struct<AnswerDataMojoType>(
    AnswerDataSpec.$,
    'AnswerData',
    [
      mojo.internal.StructField<AnswerDataMojoType, string[]>(
        'answerTextDirectives', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface SearchResultItemMojoType {
  title: string;
  url: url_mojom_Url;
  urlForDisplay: string;
  relativeTime: string;
  shortDateTime: string;
  lastUrlVisitTimestamp: number;
  sourcePassage: string;
  answerData: (AnswerData | null);
  isUrlKnownToSync: boolean;
}


export type SearchResultItem = SearchResultItemMojoType;
mojo.internal.Struct<SearchResultItemMojoType>(
    SearchResultItemSpec.$,
    'SearchResultItem',
    [
      mojo.internal.StructField<SearchResultItemMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, string>(
        'urlForDisplay', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, string>(
        'relativeTime', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, string>(
        'shortDateTime', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, number>(
        'lastUrlVisitTimestamp', 40,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, string>(
        'sourcePassage', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, AnswerData>(
        'answerData', 56,
        0,
        AnswerDataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultItemMojoType, boolean>(
        'isUrlKnownToSync', 64,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 80],]);





export interface SearchQueryMojoType {
  query: string;
  timeRangeStart: (mojoBase_mojom_Time | null);
}


export type SearchQuery = SearchQueryMojoType;
mojo.internal.Struct<SearchQueryMojoType>(
    SearchQuerySpec.$,
    'SearchQuery',
    [
      mojo.internal.StructField<SearchQueryMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchQueryMojoType, mojoBase_mojom_Time>(
        'timeRangeStart', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface SearchResultMojoType {
  query: string;
  answerStatus: AnswerStatus;
  answer: string;
  items: SearchResultItem[];
}


export type SearchResult = SearchResultMojoType;
mojo.internal.Struct<SearchResultMojoType>(
    SearchResultSpec.$,
    'SearchResult',
    [
      mojo.internal.StructField<SearchResultMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultMojoType, AnswerStatus>(
        'answerStatus', 8,
        0,
        AnswerStatusSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultMojoType, string>(
        'answer', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<SearchResultMojoType, SearchResultItem[]>(
        'items', 24,
        0,
        mojo.internal.Array(SearchResultItemSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface PageHandler_SetPage_ParamsMojoType {
  page: PageRemote;
}


export type PageHandler_SetPage_Params = PageHandler_SetPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPage_ParamsMojoType>(
    PageHandler_SetPage_ParamsSpec.$,
    'PageHandler_SetPage_Params',
    [
      mojo.internal.StructField<PageHandler_SetPage_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_Search_ParamsMojoType {
  query: SearchQuery;
}


export type PageHandler_Search_Params = PageHandler_Search_ParamsMojoType;
mojo.internal.Struct<PageHandler_Search_ParamsMojoType>(
    PageHandler_Search_ParamsSpec.$,
    'PageHandler_Search_Params',
    [
      mojo.internal.StructField<PageHandler_Search_ParamsMojoType, SearchQuery>(
        'query', 0,
        0,
        SearchQuerySpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SendQualityLog_ParamsMojoType {
  selectedIndices: number[];
  numEnteredChars: number;
}


export type PageHandler_SendQualityLog_Params = PageHandler_SendQualityLog_ParamsMojoType;
mojo.internal.Struct<PageHandler_SendQualityLog_ParamsMojoType>(
    PageHandler_SendQualityLog_ParamsSpec.$,
    'PageHandler_SendQualityLog_Params',
    [
      mojo.internal.StructField<PageHandler_SendQualityLog_ParamsMojoType, number[]>(
        'selectedIndices', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SendQualityLog_ParamsMojoType, number>(
        'numEnteredChars', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordSearchResultsMetrics_ParamsMojoType {
  nonEmptyResults: boolean;
  userClickedResult: boolean;
  answerShown: boolean;
  answerCitationClicked: boolean;
  otherHistoryResultClicked: boolean;
  queryWordCount: number;
}


export type PageHandler_RecordSearchResultsMetrics_Params = PageHandler_RecordSearchResultsMetrics_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordSearchResultsMetrics_ParamsMojoType>(
    PageHandler_RecordSearchResultsMetrics_ParamsSpec.$,
    'PageHandler_RecordSearchResultsMetrics_Params',
    [
      mojo.internal.StructField<PageHandler_RecordSearchResultsMetrics_ParamsMojoType, boolean>(
        'nonEmptyResults', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordSearchResultsMetrics_ParamsMojoType, boolean>(
        'userClickedResult', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordSearchResultsMetrics_ParamsMojoType, boolean>(
        'answerShown', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordSearchResultsMetrics_ParamsMojoType, boolean>(
        'answerCitationClicked', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordSearchResultsMetrics_ParamsMojoType, boolean>(
        'otherHistoryResultClicked', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordSearchResultsMetrics_ParamsMojoType, number>(
        'queryWordCount', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetUserFeedback_ParamsMojoType {
  feedback: UserFeedback;
}


export type PageHandler_SetUserFeedback_Params = PageHandler_SetUserFeedback_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetUserFeedback_ParamsMojoType>(
    PageHandler_SetUserFeedback_ParamsSpec.$,
    'PageHandler_SetUserFeedback_Params',
    [
      mojo.internal.StructField<PageHandler_SetUserFeedback_ParamsMojoType, UserFeedback>(
        'feedback', 0,
        0,
        UserFeedbackSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_MaybeShowFeaturePromo_ParamsMojoType {
}


export type PageHandler_MaybeShowFeaturePromo_Params = PageHandler_MaybeShowFeaturePromo_ParamsMojoType;
mojo.internal.Struct<PageHandler_MaybeShowFeaturePromo_ParamsMojoType>(
    PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
    'PageHandler_MaybeShowFeaturePromo_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OpenSettingsPage_ParamsMojoType {
}


export type PageHandler_OpenSettingsPage_Params = PageHandler_OpenSettingsPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenSettingsPage_ParamsMojoType>(
    PageHandler_OpenSettingsPage_ParamsSpec.$,
    'PageHandler_OpenSettingsPage_Params',
    [
    ],
    [[0, 8],]);





export interface Page_SearchResultChanged_ParamsMojoType {
  result: SearchResult;
}


export type Page_SearchResultChanged_Params = Page_SearchResultChanged_ParamsMojoType;
mojo.internal.Struct<Page_SearchResultChanged_ParamsMojoType>(
    Page_SearchResultChanged_ParamsSpec.$,
    'Page_SearchResultChanged_Params',
    [
      mojo.internal.StructField<Page_SearchResultChanged_ParamsMojoType, SearchResult>(
        'result', 0,
        0,
        SearchResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



