// ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_EMBEDDINGS_HISTORY_EMBEDDINGS_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_EMBEDDINGS_HISTORY_EMBEDDINGS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace history_embeddings::mojom {
class AnswerDataDataView;

class SearchResultItemDataView;

class SearchQueryDataView;

class SearchResultDataView;



}  // history_embeddings::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::history_embeddings::mojom::AnswerDataDataView> {
  using Data = ::history_embeddings::mojom::internal::AnswerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_embeddings::mojom::SearchResultItemDataView> {
  using Data = ::history_embeddings::mojom::internal::SearchResultItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_embeddings::mojom::SearchQueryDataView> {
  using Data = ::history_embeddings::mojom::internal::SearchQuery_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_embeddings::mojom::SearchResultDataView> {
  using Data = ::history_embeddings::mojom::internal::SearchResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace history_embeddings::mojom {


enum class AnswerStatus : int32_t {
  
  kUnspecified = 0,
  
  kLoading = 1,
  
  kSuccess = 2,
  
  kUnanswerable = 3,
  
  kModelUnavailable = 4,
  
  kExecutionFailure = 5,
  
  kExecutionCanceled = 6,
  
  kFiltered = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, AnswerStatus value);
inline bool IsKnownEnumValue(AnswerStatus value) {
  return internal::AnswerStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UserFeedback : int32_t {
  
  kUserFeedbackUnspecified = 0,
  
  kUserFeedbackNegative = 1,
  
  kUserFeedbackPositive = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UserFeedback value);
inline bool IsKnownEnumValue(UserFeedback value) {
  return internal::UserFeedback_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class AnswerDataDataView {
 public:
  AnswerDataDataView() = default;

  AnswerDataDataView(
      internal::AnswerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAnswerTextDirectivesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswerTextDirectives(UserType* output) {
    
    auto* pointer = data_->answer_text_directives.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AnswerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SearchResultItemDataView {
 public:
  SearchResultItemDataView() = default;

  SearchResultItemDataView(
      internal::SearchResultItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUrlForDisplayDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlForDisplay(UserType* output) {
    
    auto* pointer = data_->url_for_display.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRelativeTimeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeTime(UserType* output) {
    
    auto* pointer = data_->relative_time.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetShortDateTimeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadShortDateTime(UserType* output) {
    
    auto* pointer = data_->short_date_time.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double last_url_visit_timestamp() const {
    return data_->last_url_visit_timestamp;
  }
  inline void GetSourcePassageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourcePassage(UserType* output) {
    
    auto* pointer = data_->source_passage.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAnswerDataDataView(
      AnswerDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswerData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::history_embeddings::mojom::AnswerDataDataView, UserType>(),
    "Attempting to read the optional `answer_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnswerData` instead "
    "of `ReadAnswerData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->answer_data.Get();
    return mojo::internal::Deserialize<::history_embeddings::mojom::AnswerDataDataView>(
        pointer, output, message_);
  }
  bool is_url_known_to_sync() const {
    return data_->is_url_known_to_sync;
  }
 private:
  internal::SearchResultItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SearchQueryDataView {
 public:
  SearchQueryDataView() = default;

  SearchQueryDataView(
      internal::SearchQuery_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTimeRangeStartDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeRangeStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `time_range_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimeRangeStart` instead "
    "of `ReadTimeRangeStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->time_range_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::SearchQuery_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SearchResultDataView {
 public:
  SearchResultDataView() = default;

  SearchResultDataView(
      internal::SearchResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAnswerStatus(UserType* output) const {
    auto data_value = data_->answer_status;
    return mojo::internal::Deserialize<::history_embeddings::mojom::AnswerStatus>(
        data_value, output);
  }
  AnswerStatus answer_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::history_embeddings::mojom::AnswerStatus>(data_->answer_status));
  }
  inline void GetAnswerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswer(UserType* output) {
    
    auto* pointer = data_->answer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetItemsDataView(
      mojo::ArrayDataView<SearchResultItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_embeddings::mojom::SearchResultItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SearchResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // history_embeddings::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_EMBEDDINGS_HISTORY_EMBEDDINGS_MOJOM_DATA_VIEW_H_