// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./page_favicon.js";import"//resources/cr_elements/cr_action_menu/cr_action_menu.js";import"//resources/cr_elements/cr_icon_button/cr_icon_button.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{loadTimeData}from"//resources/js/load_time_data.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{BrowserProxyImpl}from"./browser_proxy.js";import{Annotation}from"./history_cluster_types.mojom-webui.js";import{getCss}from"./url_visit.css.js";import{getHtml}from"./url_visit.html.js";import{insertHighlightedTextWithMatchesIntoElement}from"./utils.js";const annotationToStringId=new Map([[Annotation.kBookmarked,"bookmarked"]]);const ClusterMenuElementBase=I18nMixinLit(CrLitElement);export class UrlVisitElement extends ClusterMenuElementBase{static get is(){return"url-visit"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{query:{type:String},visit:{type:Object},fromPersistence:{type:Boolean},allowDeletingHistory_:{type:Boolean},inSidePanel_:{type:Boolean,reflect:true},renderActionMenu_:{type:Boolean}}}#query_accessor_storage="";get query(){return this.#query_accessor_storage}set query(value){this.#query_accessor_storage=value}#visit_accessor_storage;get visit(){return this.#visit_accessor_storage}set visit(value){this.#visit_accessor_storage=value}#fromPersistence_accessor_storage=false;get fromPersistence(){return this.#fromPersistence_accessor_storage}set fromPersistence(value){this.#fromPersistence_accessor_storage=value}annotations_=[];#allowDeletingHistory__accessor_storage=loadTimeData.getBoolean("allowDeletingHistory");get allowDeletingHistory_(){return this.#allowDeletingHistory__accessor_storage}set allowDeletingHistory_(value){this.#allowDeletingHistory__accessor_storage=value}#inSidePanel__accessor_storage=loadTimeData.getBoolean("inSidePanel");get inSidePanel_(){return this.#inSidePanel__accessor_storage}set inSidePanel_(value){this.#inSidePanel__accessor_storage=value}#renderActionMenu__accessor_storage=false;get renderActionMenu_(){return this.#renderActionMenu__accessor_storage}set renderActionMenu_(value){this.#renderActionMenu__accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("visit")){assert(this.visit);insertHighlightedTextWithMatchesIntoElement(this.$.title,this.visit.pageTitle,this.visit.titleMatchPositions);insertHighlightedTextWithMatchesIntoElement(this.$.url,this.visit.urlForDisplay,this.visit.urlForDisplayMatchPositions)}}onAuxClick_(){this.fire("visit-clicked",this.visit)}onClick_(event){if(event.defaultPrevented){return}event.preventDefault();this.onAuxClick_();this.openUrl_(event)}onContextMenu_(event){if(!loadTimeData.getBoolean("inSidePanel")||!this.visit){return}BrowserProxyImpl.getInstance().handler.showContextMenuForURL(this.visit.normalizedUrl,{x:event.clientX,y:event.clientY})}onKeydown_(e){if(e.key!=="Enter"){return}this.onAuxClick_();this.openUrl_(e)}async onActionMenuButtonClick_(event){event.preventDefault();if(!this.renderActionMenu_){this.renderActionMenu_=true;await this.updateComplete}const menu=this.shadowRoot.querySelector("cr-action-menu");assert(menu);menu.showAt(this.$.actionMenuButton)}onHideSelfButtonClick_(event){this.emitMenuButtonClick_(event,"hide-visit")}onRemoveSelfButtonClick_(event){this.emitMenuButtonClick_(event,"remove-visit")}emitMenuButtonClick_(event,emitEventName){event.preventDefault();this.fire(emitEventName,this.visit);if(this.renderActionMenu_){const menu=this.shadowRoot.querySelector("cr-action-menu");assert(menu);menu.close()}}computeAnnotations_(){if(this.inSidePanel_||!this.visit){return[]}return this.visit.annotations.map((annotation=>annotationToStringId.get(annotation))).filter((id=>!!id)).map((id=>loadTimeData.getString(id)))}computeDebugInfo_(){if(!loadTimeData.getBoolean("isHistoryClustersDebug")||!this.visit){return""}return JSON.stringify(this.visit.debugInfo)}openUrl_(event){assert(this.visit);BrowserProxyImpl.getInstance().handler.openHistoryUrl(this.visit.normalizedUrl,{middleButton:event.button===1,altKey:event.altKey,ctrlKey:event.ctrlKey,metaKey:event.metaKey,shiftKey:event.shiftKey})}}customElements.define(UrlVisitElement.is,UrlVisitElement);