// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_SHARED_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-data-view.h"




namespace std {

template <>
struct hash<::history_clusters::mojom::ClusterAction>
    : public mojo::internal::EnumHashImpl<::history_clusters::mojom::ClusterAction> {};

template <>
struct hash<::history_clusters::mojom::RelatedSearchAction>
    : public mojo::internal::EnumHashImpl<::history_clusters::mojom::RelatedSearchAction> {};

template <>
struct hash<::history_clusters::mojom::VisitAction>
    : public mojo::internal::EnumHashImpl<::history_clusters::mojom::VisitAction> {};

template <>
struct hash<::history_clusters::mojom::VisitType>
    : public mojo::internal::EnumHashImpl<::history_clusters::mojom::VisitType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::ClusterAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_clusters::mojom::ClusterAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_clusters::mojom::ClusterAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::RelatedSearchAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_clusters::mojom::RelatedSearchAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_clusters::mojom::RelatedSearchAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::VisitAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_clusters::mojom::VisitAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_clusters::mojom::VisitAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::VisitType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_clusters::mojom::VisitType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_clusters::mojom::VisitType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::QueryResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_clusters::mojom::QueryResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_clusters::mojom::internal::QueryResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::query(input)) in_query = Traits::query(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query)::BaseType> query_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_query,
      query_fragment);

    fragment->query.Set(
        query_fragment.is_null() ? nullptr : query_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->query.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query in QueryResult struct");

    decltype(Traits::clusters(input)) in_clusters = Traits::clusters(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clusters)::BaseType>
        clusters_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& clusters_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::ClusterDataView>>(
      in_clusters,
      clusters_fragment,
      &clusters_validate_params);

    fragment->clusters.Set(
        clusters_fragment.is_null() ? nullptr : clusters_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->clusters.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clusters in QueryResult struct");

    fragment->can_load_more = Traits::can_load_more(input);

    fragment->is_continuation = Traits::is_continuation(input);
  }

  static bool Deserialize(::history_clusters::mojom::internal::QueryResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_clusters::mojom::QueryResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace history_clusters::mojom {

inline void QueryResultDataView::GetQueryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void QueryResultDataView::GetClustersDataView(
    mojo::ArrayDataView<::history_clusters::mojom::ClusterDataView>* output) {
  auto pointer = data_->clusters.Get();
  *output = mojo::ArrayDataView<::history_clusters::mojom::ClusterDataView>(pointer, message_);
}



}  // history_clusters::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_clusters::mojom::ClusterAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_clusters::mojom::ClusterAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_clusters::mojom::RelatedSearchAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_clusters::mojom::RelatedSearchAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_clusters::mojom::VisitAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_clusters::mojom::VisitAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_clusters::mojom::VisitType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_clusters::mojom::VisitType value);
};

} // namespace perfetto

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_SHARED_H_