// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// vector_icons.cc.template is used to generate vector_icons.cc. Edit the former
// rather than the latter.

#include "ui/message_center/vector_icons.h"

#include "components/vector_icons/cc_macros.h"
#include "ui/gfx/vector_icon_types.h"

#define DECLARE_VECTOR_COMMAND(x) using gfx::x;
DECLARE_VECTOR_COMMANDS

namespace message_center {

VECTOR_ICON_REP_TEMPLATE(kNotificationCloseButtonPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 20, 5.73,
LINE_TO, 18.27, 4,
LINE_TO, 12, 10.27,
LINE_TO, 5.73, 4,
LINE_TO, 4, 5.73,
LINE_TO, 10.27, 12,
LINE_TO, 4, 18.27,
LINE_TO, 5.73, 20,
LINE_TO, 12, 13.73,
LINE_TO, 18.27, 20,
LINE_TO, 20, 18.27,
LINE_TO, 13.73, 12,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNotificationCloseButton12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 10.5, 2.36,
LINE_TO, 9.64, 1.5,
LINE_TO, 6, 5.14,
LINE_TO, 2.36, 1.5,
LINE_TO, 1.5, 2.36,
LINE_TO, 5.14, 6,
LINE_TO, 1.5, 9.64,
LINE_TO, 2.36, 10.5,
LINE_TO, 6, 6.86,
LINE_TO, 9.64, 10.5,
LINE_TO, 10.5, 9.64,
LINE_TO, 6.86, 6,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationCloseButtonRepList, kNotificationCloseButtonIcon, {kNotificationCloseButtonPath}, {kNotificationCloseButton12Path})
VECTOR_ICON_REP_TEMPLATE(kNotificationExpandLessPath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2.62, 13,
LINE_TO, 8, 7.75,
LINE_TO, 13.33, 13,
LINE_TO, 15, 11.31,
R_LINE_TO, -7, -6.89,
R_LINE_TO, -7, 6.89,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationExpandLessRepList, kNotificationExpandLessIcon, {kNotificationExpandLessPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationExpandMorePath, CANVAS_DIMENSIONS, 16,
MOVE_TO, 2.62, 3,
LINE_TO, 8, 8.25,
LINE_TO, 13.33, 3,
LINE_TO, 15, 4.69,
R_LINE_TO, -7, 6.89,
R_LINE_TO, -7, -6.89,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationExpandMoreRepList, kNotificationExpandMoreIcon, {kNotificationExpandMorePath})
VECTOR_ICON_REP_TEMPLATE(kNotificationInlineReplyPath, CANVAS_DIMENSIONS, 96,
MOVE_TO, 10.04, 82,
LINE_TO, 86, 48,
LINE_TO, 10.04, 14,
LINE_TO, 10, 40.44,
LINE_TO, 64.29, 48,
LINE_TO, 10, 55.56,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationInlineReplyRepList, kNotificationInlineReplyIcon, {kNotificationInlineReplyPath})
VECTOR_ICON_REP_TEMPLATE(kNotificationSettingsButtonPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 19.63, 12.98,
CUBIC_TO, 19.68, 12.66, 19.71, 12.33, 19.71, 12,
CUBIC_TO, 19.71, 11.67, 19.68, 11.35, 19.63, 11.03,
LINE_TO, 21.81, 9.37,
CUBIC_TO, 22, 9.22, 22.06, 8.95, 21.93, 8.73,
LINE_TO, 19.88, 5.27,
CUBIC_TO, 19.75, 5.05, 19.48, 4.96, 19.25, 5.05,
LINE_TO, 16.69, 6.06,
CUBIC_TO, 16.16, 5.66, 15.58, 5.33, 14.95, 5.07,
LINE_TO, 14.57, 2.42,
CUBIC_TO, 14.52, 2.19, 14.31, 2, 14.05, 2,
LINE_TO, 9.94, 2,
CUBIC_TO, 9.68, 2, 9.47, 2.19, 9.43, 2.42,
LINE_TO, 9.05, 5.07,
CUBIC_TO, 8.42, 5.33, 7.84, 5.66, 7.31, 6.06,
LINE_TO, 4.75, 5.05,
CUBIC_TO, 4.52, 4.97, 4.25, 5.05, 4.12, 5.27,
LINE_TO, 2.07, 8.73,
CUBIC_TO, 1.94, 8.95, 2, 9.22, 2.19, 9.37,
LINE_TO, 4.36, 11.03,
CUBIC_TO, 4.32, 11.35, 4.29, 11.67, 4.29, 12,
CUBIC_TO, 4.29, 12.33, 4.32, 12.66, 4.36, 12.98,
LINE_TO, 2.19, 14.63,
CUBIC_TO, 2, 14.78, 1.94, 15.05, 2.07, 15.27,
LINE_TO, 4.12, 18.74,
CUBIC_TO, 4.25, 18.95, 4.52, 19.04, 4.75, 18.95,
LINE_TO, 7.31, 17.95,
CUBIC_TO, 7.84, 18.34, 8.42, 18.68, 9.05, 18.93,
LINE_TO, 9.43, 21.58,
CUBIC_TO, 9.47, 21.82, 9.68, 22, 9.94, 22,
LINE_TO, 14.05, 22,
CUBIC_TO, 14.31, 22, 14.52, 21.82, 14.56, 21.58,
LINE_TO, 14.95, 18.93,
CUBIC_TO, 15.57, 18.68, 16.15, 18.35, 16.68, 17.95,
LINE_TO, 19.24, 18.95,
CUBIC_TO, 19.47, 19.04, 19.74, 18.95, 19.87, 18.74,
LINE_TO, 21.93, 15.27,
CUBIC_TO, 22.05, 15.06, 22, 14.79, 21.8, 14.63,
LINE_TO, 19.63, 12.98,
LINE_TO, 19.63, 12.98,
CLOSE,
MOVE_TO, 12, 15,
CUBIC_TO, 10.34, 15, 9, 13.66, 9, 12,
CUBIC_TO, 9, 10.34, 10.34, 9, 12, 9,
CUBIC_TO, 13.66, 9, 15, 10.34, 15, 12,
CUBIC_TO, 15, 13.66, 13.66, 15, 12, 15,
LINE_TO, 12, 15,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNotificationSettingsButton12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 9.82, 6.49,
CUBIC_TO, 9.84, 6.33, 9.85, 6.17, 9.85, 6,
CUBIC_TO, 9.85, 5.84, 9.84, 5.67, 9.82, 5.51,
LINE_TO, 10.9, 4.68,
CUBIC_TO, 11, 4.61, 11.03, 4.47, 10.97, 4.37,
LINE_TO, 9.94, 2.63,
CUBIC_TO, 9.87, 2.53, 9.74, 2.48, 9.62, 2.53,
LINE_TO, 8.34, 3.03,
CUBIC_TO, 8.08, 2.83, 7.79, 2.66, 7.48, 2.54,
LINE_TO, 7.28, 1.21,
CUBIC_TO, 7.26, 1.09, 7.15, 1, 7.03, 1,
LINE_TO, 4.97, 1,
CUBIC_TO, 4.84, 1, 4.74, 1.09, 4.72, 1.21,
LINE_TO, 4.52, 2.54,
CUBIC_TO, 4.21, 2.66, 3.92, 2.83, 3.66, 3.03,
LINE_TO, 2.38, 2.53,
CUBIC_TO, 2.26, 2.48, 2.13, 2.53, 2.06, 2.63,
LINE_TO, 1.03, 4.37,
CUBIC_TO, 0.97, 4.47, 1, 4.61, 1.1, 4.68,
LINE_TO, 2.18, 5.51,
CUBIC_TO, 2.16, 5.67, 2.14, 5.84, 2.14, 6,
CUBIC_TO, 2.14, 6.17, 2.16, 6.33, 2.18, 6.49,
LINE_TO, 1.1, 7.32,
CUBIC_TO, 1, 7.39, 0.97, 7.53, 1.03, 7.64,
LINE_TO, 2.06, 9.37,
CUBIC_TO, 2.13, 9.48, 2.26, 9.52, 2.38, 9.48,
LINE_TO, 3.66, 8.97,
CUBIC_TO, 3.92, 9.17, 4.21, 9.34, 4.52, 9.47,
LINE_TO, 4.72, 10.79,
CUBIC_TO, 4.74, 10.91, 4.84, 11, 4.97, 11,
LINE_TO, 7.03, 11,
CUBIC_TO, 7.15, 11, 7.26, 10.91, 7.28, 10.79,
LINE_TO, 7.47, 9.47,
CUBIC_TO, 7.79, 9.34, 8.08, 9.17, 8.34, 8.97,
LINE_TO, 9.62, 9.48,
CUBIC_TO, 9.74, 9.52, 9.87, 9.48, 9.94, 9.37,
LINE_TO, 10.96, 7.64,
CUBIC_TO, 11.03, 7.53, 11, 7.39, 10.9, 7.32,
LINE_TO, 9.82, 6.49,
LINE_TO, 9.82, 6.49,
CLOSE,
MOVE_TO, 6, 7.5,
CUBIC_TO, 5.17, 7.5, 4.5, 6.83, 4.5, 6,
CUBIC_TO, 4.5, 5.17, 5.17, 4.5, 6, 4.5,
CUBIC_TO, 6.83, 4.5, 7.5, 5.17, 7.5, 6,
CUBIC_TO, 7.5, 6.83, 6.83, 7.5, 6, 7.5,
LINE_TO, 6, 7.5,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationSettingsButtonRepList, kNotificationSettingsButtonIcon, {kNotificationSettingsButtonPath}, {kNotificationSettingsButton12Path})
VECTOR_ICON_REP_TEMPLATE(kNotificationSnoozeButtonPath, CANVAS_DIMENSIONS, 24,
MOVE_TO, 12, 2,
ARC_TO, 10, 10, 0, 1, 0, 12, 22,
ARC_TO, 10, 10, 0, 0, 0, 12, 2,
CLOSE,
MOVE_TO, 12, 20,
R_ARC_TO, 8, 8, 0, 1, 1, 0, -16,
R_ARC_TO, 8, 8, 0, 0, 1, 0, 16,
CLOSE,
MOVE_TO, 12.5, 7,
H_LINE_TO, 11,
R_V_LINE_TO, 6,
R_LINE_TO, 5.25, 3.15,
R_LINE_TO, 0.75, -1.23,
R_LINE_TO, -4.5, -2.67,
CLOSE)
VECTOR_ICON_REP_TEMPLATE(kNotificationSnoozeButton12Path, CANVAS_DIMENSIONS, 12,
MOVE_TO, 6, 1,
R_ARC_TO, 5, 5, 0, 0, 0, -5, 5,
R_ARC_TO, 5, 5, 0, 0, 0, 5, 5,
R_ARC_TO, 5, 5, 0, 0, 0, 5, -5,
R_ARC_TO, 5, 5, 0, 0, 0, -5, -5,
CLOSE,
R_MOVE_TO, 0, 9,
R_ARC_TO, 4, 4, 0, 1, 1, 0, -8,
R_ARC_TO, 4, 4, 0, 0, 1, 0, 8,
CLOSE,
MOVE_TO, 6.25, 3.5,
H_LINE_TO, 5.5,
R_V_LINE_TO, 3,
R_LINE_TO, 2.63, 1.57,
R_LINE_TO, 0.37, -0.61,
R_LINE_TO, -2.25, -1.34,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kNotificationSnoozeButtonRepList, kNotificationSnoozeButtonIcon, {kNotificationSnoozeButtonPath}, {kNotificationSnoozeButton12Path})
VECTOR_ICON_REP_TEMPLATE(kProductPath, CANVAS_DIMENSIONS, 96,
MOVE_TO, 84.25, 30.5,
CUBIC_TO, 77.85, 17.3, 63.6, 8, 48, 8,
R_CUBIC_TO, -12.4, 0, -23.6, 5.6, -30.8, 14.4,
R_LINE_TO, 13.2, 22.8,
R_CUBIC_TO, 1.2, -8.4, 8.8, -14.7, 17.6, -14.7,
R_H_LINE_TO, 36.25,
CLOSE,
MOVE_TO, 48, 66,
R_CUBIC_TO, -6.8, 0, -12.4, -3.6, -15.6, -9.2,
LINE_TO, 14.4, 26,
CUBIC_TO, 10.4, 32.4, 8, 40, 8, 48,
R_CUBIC_TO, 0, 20, 14.4, 36.4, 33.6, 39.6,
R_LINE_TO, 13.2, -22.8,
R_CUBIC_TO, -2.4, 0.8, -4.4, 1.2, -6.8, 1.2,
CLOSE,
R_MOVE_TO, 18, -18,
R_CUBIC_TO, 0, -5.6, -4, -11.8, -8, -15,
R_H_LINE_TO, 27.5,
R_CUBIC_TO, 1.6, 4.4, 2.5, 10.2, 2.5, 15,
R_CUBIC_TO, 0, 22, -18, 40, -40, 40,
R_H_LINE_TO, -2.4,
R_LINE_TO, 18, -31.2,
R_CUBIC_TO, 1.6, -2.4, 2.4, -5.6, 2.4, -8.8,
CLOSE,
MOVE_TO, 48, 62,
R_CUBIC_TO, -7.73, 0, -14, -6.27, -14, -14,
R_CUBIC_TO, 0, -7.73, 6.27, -14, 14, -14,
R_CUBIC_TO, 7.73, 0, 14, 6.27, 14, 14,
R_CUBIC_TO, 0, 7.73, -6.27, 14, -14, 14,
CLOSE)
VECTOR_ICON_TEMPLATE_CC(kProductRepList, kProductIcon, {kProductPath})

}
