// ui/gfx/mojom/mask_filter_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/mask_filter_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "ui/gfx/mojom/linear_gradient.mojom-shared.h"




#include "ui/gfx/mojom/mask_filter_info.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::MaskFilterInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::MaskFilterInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::MaskFilterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::rounded_corner_bounds(input)) in_rounded_corner_bounds = Traits::rounded_corner_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rounded_corner_bounds)::BaseType> rounded_corner_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RRectFDataView>(
      in_rounded_corner_bounds,
      rounded_corner_bounds_fragment);

    fragment->rounded_corner_bounds.Set(
        rounded_corner_bounds_fragment.is_null() ? nullptr : rounded_corner_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rounded_corner_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rounded_corner_bounds in MaskFilterInfo struct");

    decltype(Traits::gradient_mask(input)) in_gradient_mask = Traits::gradient_mask(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gradient_mask)::BaseType> gradient_mask_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::LinearGradientDataView>(
      in_gradient_mask,
      gradient_mask_fragment);

    fragment->gradient_mask.Set(
        gradient_mask_fragment.is_null() ? nullptr : gradient_mask_fragment.data());
    fragment->clip_id_$flag = Traits::clip_id(input).has_value();
    if (Traits::clip_id(input).has_value()) {
      fragment->clip_id_$value = Traits::clip_id(input).value();
    }
  }

  static bool Deserialize(::gfx::mojom::internal::MaskFilterInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::MaskFilterInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {

inline void MaskFilterInfoDataView::GetRoundedCornerBoundsDataView(
    ::gfx::mojom::RRectFDataView* output) {
  auto pointer = data_->rounded_corner_bounds.Get();
  *output = ::gfx::mojom::RRectFDataView(pointer, message_);
}
inline void MaskFilterInfoDataView::GetGradientMaskDataView(
    ::gfx::mojom::LinearGradientDataView* output) {
  auto pointer = data_->gradient_mask.Get();
  *output = ::gfx::mojom::LinearGradientDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_SHARED_H_