// ui/gfx/mojom/mask_filter_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/mask_filter_info.mojom-shared-internal.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "ui/gfx/mojom/linear_gradient.mojom-shared.h"

#include "ui/gfx/mojom/mask_filter_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::MaskFilterInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::MaskFilterInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::MaskFilterInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::rounded_corner_bounds(input)) in_rounded_corner_bounds = Traits::rounded_corner_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rounded_corner_bounds)::BaseType> rounded_corner_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RRectFDataView, send_validation>(
        in_rounded_corner_bounds,
        rounded_corner_bounds_fragment);

      fragment->rounded_corner_bounds.Set(
          rounded_corner_bounds_fragment.is_null() ? nullptr : rounded_corner_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rounded_corner_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rounded_corner_bounds in MaskFilterInfo struct");

      decltype(Traits::gradient_mask(input)) in_gradient_mask = Traits::gradient_mask(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->gradient_mask)::BaseType> gradient_mask_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::LinearGradientDataView, send_validation>(
        in_gradient_mask,
        gradient_mask_fragment);

      fragment->gradient_mask.Set(
          gradient_mask_fragment.is_null() ? nullptr : gradient_mask_fragment.data());
      fragment->clip_id_$flag = Traits::clip_id(input).has_value();
      if (Traits::clip_id(input).has_value()) {
        fragment->clip_id_$value = Traits::clip_id(input).value();
      }
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_MASK_FILTER_INFO_MOJOM_SEND_VALIDATION_H_