// ui/gfx/mojom/hdr_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gfx/mojom/hdr_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gfx.mojom');
  var skcolorspace_primaries$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolorspace_primaries.mojom', '../../../skia/public/mojom/skcolorspace_primaries.mojom.js');
  }



  function HdrMetadataCta861_3(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HdrMetadataCta861_3.prototype.initDefaults_ = function() {
    this.maxContentLightLevel = 0;
    this.maxFrameAverageLightLevel = 0;
  };
  HdrMetadataCta861_3.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HdrMetadataCta861_3.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  HdrMetadataCta861_3.encodedSize = codec.kStructHeaderSize + 8;

  HdrMetadataCta861_3.decode = function(decoder) {
    var packed;
    var val = new HdrMetadataCta861_3();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.maxContentLightLevel =
        decoder.decodeStruct(codec.Uint32);
    val.maxFrameAverageLightLevel =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  HdrMetadataCta861_3.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HdrMetadataCta861_3.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.maxContentLightLevel);
    encoder.encodeStruct(codec.Uint32, val.maxFrameAverageLightLevel);
  };
  function HdrMetadataSmpteSt2086(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HdrMetadataSmpteSt2086.prototype.initDefaults_ = function() {
    this.primaries = null;
    this.luminanceMax = 0;
    this.luminanceMin = 0;
  };
  HdrMetadataSmpteSt2086.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HdrMetadataSmpteSt2086.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HdrMetadataSmpteSt2086.primaries
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolorspace_primaries$.SkColorSpacePrimaries, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  HdrMetadataSmpteSt2086.encodedSize = codec.kStructHeaderSize + 16;

  HdrMetadataSmpteSt2086.decode = function(decoder) {
    var packed;
    var val = new HdrMetadataSmpteSt2086();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.primaries =
        decoder.decodeStructPointer(skcolorspace_primaries$.SkColorSpacePrimaries);
    val.luminanceMax =
        decoder.decodeStruct(codec.Float);
    val.luminanceMin =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  HdrMetadataSmpteSt2086.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HdrMetadataSmpteSt2086.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolorspace_primaries$.SkColorSpacePrimaries, val.primaries);
    encoder.encodeStruct(codec.Float, val.luminanceMax);
    encoder.encodeStruct(codec.Float, val.luminanceMin);
  };
  function HdrMetadataNdwl(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HdrMetadataNdwl.prototype.initDefaults_ = function() {
    this.nits = 0;
  };
  HdrMetadataNdwl.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HdrMetadataNdwl.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HdrMetadataNdwl.encodedSize = codec.kStructHeaderSize + 8;

  HdrMetadataNdwl.decode = function(decoder) {
    var packed;
    var val = new HdrMetadataNdwl();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nits =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HdrMetadataNdwl.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HdrMetadataNdwl.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.nits);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HdrMetadataExtendedRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HdrMetadataExtendedRange.prototype.initDefaults_ = function() {
    this.currentHeadroom = 0;
    this.desiredHeadroom = 0;
  };
  HdrMetadataExtendedRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HdrMetadataExtendedRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  HdrMetadataExtendedRange.encodedSize = codec.kStructHeaderSize + 8;

  HdrMetadataExtendedRange.decode = function(decoder) {
    var packed;
    var val = new HdrMetadataExtendedRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currentHeadroom =
        decoder.decodeStruct(codec.Float);
    val.desiredHeadroom =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  HdrMetadataExtendedRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HdrMetadataExtendedRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.currentHeadroom);
    encoder.encodeStruct(codec.Float, val.desiredHeadroom);
  };
  function HdrMetadataAgtm(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HdrMetadataAgtm.prototype.initDefaults_ = function() {
    this.payload = null;
  };
  HdrMetadataAgtm.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HdrMetadataAgtm.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HdrMetadataAgtm.payload
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HdrMetadataAgtm.encodedSize = codec.kStructHeaderSize + 8;

  HdrMetadataAgtm.decode = function(decoder) {
    var packed;
    var val = new HdrMetadataAgtm();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.payload =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  HdrMetadataAgtm.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HdrMetadataAgtm.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.payload);
  };
  function HDRMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HDRMetadata.prototype.initDefaults_ = function() {
    this.smpteSt2086 = null;
    this.cta8613 = null;
    this.ndwl = null;
    this.extendedRange = null;
    this.agtm = null;
  };
  HDRMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HDRMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HDRMetadata.smpteSt2086
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HdrMetadataSmpteSt2086, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HDRMetadata.cta8613
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, HdrMetadataCta861_3, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HDRMetadata.ndwl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, HdrMetadataNdwl, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HDRMetadata.extendedRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, HdrMetadataExtendedRange, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HDRMetadata.agtm
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, HdrMetadataAgtm, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HDRMetadata.encodedSize = codec.kStructHeaderSize + 40;

  HDRMetadata.decode = function(decoder) {
    var packed;
    var val = new HDRMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.smpteSt2086 =
        decoder.decodeStructPointer(HdrMetadataSmpteSt2086);
    val.cta8613 =
        decoder.decodeStructPointer(HdrMetadataCta861_3);
    val.ndwl =
        decoder.decodeStructPointer(HdrMetadataNdwl);
    val.extendedRange =
        decoder.decodeStructPointer(HdrMetadataExtendedRange);
    val.agtm =
        decoder.decodeStructPointer(HdrMetadataAgtm);
    return val;
  };

  HDRMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HDRMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HdrMetadataSmpteSt2086, val.smpteSt2086);
    encoder.encodeStructPointer(HdrMetadataCta861_3, val.cta8613);
    encoder.encodeStructPointer(HdrMetadataNdwl, val.ndwl);
    encoder.encodeStructPointer(HdrMetadataExtendedRange, val.extendedRange);
    encoder.encodeStructPointer(HdrMetadataAgtm, val.agtm);
  };
  exports.HdrMetadataCta861_3 = HdrMetadataCta861_3;
  exports.HdrMetadataSmpteSt2086 = HdrMetadataSmpteSt2086;
  exports.HdrMetadataNdwl = HdrMetadataNdwl;
  exports.HdrMetadataExtendedRange = HdrMetadataExtendedRange;
  exports.HdrMetadataAgtm = HdrMetadataAgtm;
  exports.HDRMetadata = HDRMetadata;
})();