// ui/gfx/mojom/hdr_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_HDR_METADATA_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_HDR_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/hdr_metadata.mojom-shared-internal.h"
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"




#include "ui/gfx/mojom/hdr_metadata.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::HdrMetadataCta861_3DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::HdrMetadataCta861_3DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::HdrMetadataCta861_3_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->max_content_light_level = Traits::max_content_light_level(input);

    fragment->max_frame_average_light_level = Traits::max_frame_average_light_level(input);
  }

  static bool Deserialize(::gfx::mojom::internal::HdrMetadataCta861_3_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::HdrMetadataCta861_3DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::HdrMetadataSmpteSt2086DataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::HdrMetadataSmpteSt2086DataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::HdrMetadataSmpteSt2086_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::primaries(input)) in_primaries = Traits::primaries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primaries)::BaseType> primaries_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorSpacePrimariesDataView>(
      in_primaries,
      primaries_fragment);

    fragment->primaries.Set(
        primaries_fragment.is_null() ? nullptr : primaries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primaries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primaries in HdrMetadataSmpteSt2086 struct");

    fragment->luminance_max = Traits::luminance_max(input);

    fragment->luminance_min = Traits::luminance_min(input);
  }

  static bool Deserialize(::gfx::mojom::internal::HdrMetadataSmpteSt2086_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::HdrMetadataSmpteSt2086DataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::HdrMetadataNdwlDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::HdrMetadataNdwlDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::HdrMetadataNdwl_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->nits = Traits::nits(input);
  }

  static bool Deserialize(::gfx::mojom::internal::HdrMetadataNdwl_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::HdrMetadataNdwlDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::HdrMetadataExtendedRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::HdrMetadataExtendedRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::HdrMetadataExtendedRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->current_headroom = Traits::current_headroom(input);

    fragment->desired_headroom = Traits::desired_headroom(input);
  }

  static bool Deserialize(::gfx::mojom::internal::HdrMetadataExtendedRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::HdrMetadataExtendedRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::HdrMetadataAgtmDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::HdrMetadataAgtmDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::HdrMetadataAgtm_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::payload(input)) in_payload = Traits::payload(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->payload)::BaseType>
        payload_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& payload_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_payload,
      payload_fragment,
      &payload_validate_params);

    fragment->payload.Set(
        payload_fragment.is_null() ? nullptr : payload_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payload.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payload in HdrMetadataAgtm struct");
  }

  static bool Deserialize(::gfx::mojom::internal::HdrMetadataAgtm_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::HdrMetadataAgtmDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::HDRMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::HDRMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::HDRMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::smpte_st_2086(input)) in_smpte_st_2086 = Traits::smpte_st_2086(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->smpte_st_2086)::BaseType> smpte_st_2086_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HdrMetadataSmpteSt2086DataView>(
      in_smpte_st_2086,
      smpte_st_2086_fragment);

    fragment->smpte_st_2086.Set(
        smpte_st_2086_fragment.is_null() ? nullptr : smpte_st_2086_fragment.data());

    decltype(Traits::cta_861_3(input)) in_cta_861_3 = Traits::cta_861_3(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cta_861_3)::BaseType> cta_861_3_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HdrMetadataCta861_3DataView>(
      in_cta_861_3,
      cta_861_3_fragment);

    fragment->cta_861_3.Set(
        cta_861_3_fragment.is_null() ? nullptr : cta_861_3_fragment.data());

    decltype(Traits::ndwl(input)) in_ndwl = Traits::ndwl(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ndwl)::BaseType> ndwl_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HdrMetadataNdwlDataView>(
      in_ndwl,
      ndwl_fragment);

    fragment->ndwl.Set(
        ndwl_fragment.is_null() ? nullptr : ndwl_fragment.data());

    decltype(Traits::extended_range(input)) in_extended_range = Traits::extended_range(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extended_range)::BaseType> extended_range_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HdrMetadataExtendedRangeDataView>(
      in_extended_range,
      extended_range_fragment);

    fragment->extended_range.Set(
        extended_range_fragment.is_null() ? nullptr : extended_range_fragment.data());

    decltype(Traits::agtm(input)) in_agtm = Traits::agtm(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->agtm)::BaseType> agtm_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::HdrMetadataAgtmDataView>(
      in_agtm,
      agtm_fragment);

    fragment->agtm.Set(
        agtm_fragment.is_null() ? nullptr : agtm_fragment.data());
  }

  static bool Deserialize(::gfx::mojom::internal::HDRMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::HDRMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {



inline void HdrMetadataSmpteSt2086DataView::GetPrimariesDataView(
    ::skia::mojom::SkColorSpacePrimariesDataView* output) {
  auto pointer = data_->primaries.Get();
  *output = ::skia::mojom::SkColorSpacePrimariesDataView(pointer, message_);
}






inline void HdrMetadataAgtmDataView::GetPayloadDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->payload.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void HDRMetadataDataView::GetSmpteSt2086DataView(
    HdrMetadataSmpteSt2086DataView* output) {
  auto pointer = data_->smpte_st_2086.Get();
  *output = HdrMetadataSmpteSt2086DataView(pointer, message_);
}
inline void HDRMetadataDataView::GetCta8613DataView(
    HdrMetadataCta861_3DataView* output) {
  auto pointer = data_->cta_861_3.Get();
  *output = HdrMetadataCta861_3DataView(pointer, message_);
}
inline void HDRMetadataDataView::GetNdwlDataView(
    HdrMetadataNdwlDataView* output) {
  auto pointer = data_->ndwl.Get();
  *output = HdrMetadataNdwlDataView(pointer, message_);
}
inline void HDRMetadataDataView::GetExtendedRangeDataView(
    HdrMetadataExtendedRangeDataView* output) {
  auto pointer = data_->extended_range.Get();
  *output = HdrMetadataExtendedRangeDataView(pointer, message_);
}
inline void HDRMetadataDataView::GetAgtmDataView(
    HdrMetadataAgtmDataView* output) {
  auto pointer = data_->agtm.Get();
  *output = HdrMetadataAgtmDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_GFX_MOJOM_HDR_METADATA_MOJOM_SHARED_H_