// ui/gfx/geometry/mojom/geometry.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_GEOMETRY_MOJOM_GEOMETRY_MOJOM_H_
#define UI_GFX_GEOMETRY_MOJOM_GEOMETRY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/geometry/mojom/geometry.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "ui/gfx/geometry/mojom/geometry_mojom_traits.h"




namespace gfx::mojom {





class  Point {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Point, T>::value>;
  using DataView = PointDataView;
  using Data_ = internal::Point_Data;

  template <typename... Args>
  static PointPtr New(Args&&... args) {
    return PointPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PointPtr From(const U& u) {
    return mojo::TypeConverter<PointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Point>::Convert(*this);
  }


  Point();

  Point(
      int32_t x,
      int32_t y);


  ~Point();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PointPtr>
  PointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Point::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Point::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Point::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Point::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Point::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Point::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Point_UnserializedMessageContext<
            UserType, Point::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Point::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Point::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Point_UnserializedMessageContext<
            UserType, Point::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Point::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t x;
  
  int32_t y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Point::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Point::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Point::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Point::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PointF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PointF, T>::value>;
  using DataView = PointFDataView;
  using Data_ = internal::PointF_Data;

  template <typename... Args>
  static PointFPtr New(Args&&... args) {
    return PointFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PointFPtr From(const U& u) {
    return mojo::TypeConverter<PointFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PointF>::Convert(*this);
  }


  PointF();

  PointF(
      float x,
      float y);


  ~PointF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PointFPtr>
  PointFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PointF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PointF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PointF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PointF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PointF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PointF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PointF_UnserializedMessageContext<
            UserType, PointF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PointF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PointF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PointF_UnserializedMessageContext<
            UserType, PointF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PointF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PointF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PointF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PointF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PointF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Point3F {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Point3F, T>::value>;
  using DataView = Point3FDataView;
  using Data_ = internal::Point3F_Data;

  template <typename... Args>
  static Point3FPtr New(Args&&... args) {
    return Point3FPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Point3FPtr From(const U& u) {
    return mojo::TypeConverter<Point3FPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Point3F>::Convert(*this);
  }


  Point3F();

  Point3F(
      float x,
      float y,
      float z);


  ~Point3F();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Point3FPtr>
  Point3FPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Point3F::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Point3F::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Point3F::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Point3F::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Point3F::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Point3F::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Point3F_UnserializedMessageContext<
            UserType, Point3F::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Point3F::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Point3F::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Point3F_UnserializedMessageContext<
            UserType, Point3F::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Point3F::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;
  
  float z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Point3F::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Point3F::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Point3F::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Point3F::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Size {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Size, T>::value>;
  using DataView = SizeDataView;
  using Data_ = internal::Size_Data;

  template <typename... Args>
  static SizePtr New(Args&&... args) {
    return SizePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SizePtr From(const U& u) {
    return mojo::TypeConverter<SizePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Size>::Convert(*this);
  }


  Size();

  Size(
      int32_t width,
      int32_t height);


  ~Size();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SizePtr>
  SizePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Size::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Size::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Size::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Size::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Size::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Size::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Size_UnserializedMessageContext<
            UserType, Size::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Size::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Size::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Size_UnserializedMessageContext<
            UserType, Size::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Size::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t width;
  
  int32_t height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Size::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Size::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Size::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Size::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SizeF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SizeF, T>::value>;
  using DataView = SizeFDataView;
  using Data_ = internal::SizeF_Data;

  template <typename... Args>
  static SizeFPtr New(Args&&... args) {
    return SizeFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SizeFPtr From(const U& u) {
    return mojo::TypeConverter<SizeFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SizeF>::Convert(*this);
  }


  SizeF();

  SizeF(
      float width,
      float height);


  ~SizeF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SizeFPtr>
  SizeFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SizeF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SizeF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SizeF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SizeF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SizeF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SizeF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SizeF_UnserializedMessageContext<
            UserType, SizeF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SizeF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SizeF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SizeF_UnserializedMessageContext<
            UserType, SizeF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SizeF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float width;
  
  float height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SizeF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SizeF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SizeF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SizeF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Rect {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Rect, T>::value>;
  using DataView = RectDataView;
  using Data_ = internal::Rect_Data;

  template <typename... Args>
  static RectPtr New(Args&&... args) {
    return RectPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RectPtr From(const U& u) {
    return mojo::TypeConverter<RectPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Rect>::Convert(*this);
  }


  Rect();

  Rect(
      int32_t x,
      int32_t y,
      int32_t width,
      int32_t height);


  ~Rect();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RectPtr>
  RectPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Rect::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Rect::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Rect::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Rect::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Rect::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Rect::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Rect_UnserializedMessageContext<
            UserType, Rect::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Rect::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Rect::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Rect_UnserializedMessageContext<
            UserType, Rect::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Rect::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t x;
  
  int32_t y;
  
  int32_t width;
  
  int32_t height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Rect::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Rect::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Rect::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Rect::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RectF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RectF, T>::value>;
  using DataView = RectFDataView;
  using Data_ = internal::RectF_Data;

  template <typename... Args>
  static RectFPtr New(Args&&... args) {
    return RectFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RectFPtr From(const U& u) {
    return mojo::TypeConverter<RectFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RectF>::Convert(*this);
  }


  RectF();

  RectF(
      float x,
      float y,
      float width,
      float height);


  ~RectF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RectFPtr>
  RectFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RectF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RectF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RectF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RectF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RectF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RectF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RectF_UnserializedMessageContext<
            UserType, RectF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RectF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RectF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RectF_UnserializedMessageContext<
            UserType, RectF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RectF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;
  
  float width;
  
  float height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RectF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RectF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RectF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RectF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Insets {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Insets, T>::value>;
  using DataView = InsetsDataView;
  using Data_ = internal::Insets_Data;

  template <typename... Args>
  static InsetsPtr New(Args&&... args) {
    return InsetsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InsetsPtr From(const U& u) {
    return mojo::TypeConverter<InsetsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Insets>::Convert(*this);
  }


  Insets();

  Insets(
      int32_t top,
      int32_t left,
      int32_t bottom,
      int32_t right);


  ~Insets();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InsetsPtr>
  InsetsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Insets::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Insets::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Insets::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Insets::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Insets::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Insets::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Insets_UnserializedMessageContext<
            UserType, Insets::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Insets::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Insets::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Insets_UnserializedMessageContext<
            UserType, Insets::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Insets::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t top;
  
  int32_t left;
  
  int32_t bottom;
  
  int32_t right;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Insets::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Insets::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Insets::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Insets::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InsetsF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InsetsF, T>::value>;
  using DataView = InsetsFDataView;
  using Data_ = internal::InsetsF_Data;

  template <typename... Args>
  static InsetsFPtr New(Args&&... args) {
    return InsetsFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InsetsFPtr From(const U& u) {
    return mojo::TypeConverter<InsetsFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InsetsF>::Convert(*this);
  }


  InsetsF();

  InsetsF(
      float top,
      float left,
      float bottom,
      float right);


  ~InsetsF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InsetsFPtr>
  InsetsFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InsetsF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InsetsF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InsetsF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InsetsF_UnserializedMessageContext<
            UserType, InsetsF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InsetsF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InsetsF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InsetsF_UnserializedMessageContext<
            UserType, InsetsF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InsetsF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float top;
  
  float left;
  
  float bottom;
  
  float right;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InsetsF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Vector2d {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vector2d, T>::value>;
  using DataView = Vector2dDataView;
  using Data_ = internal::Vector2d_Data;

  template <typename... Args>
  static Vector2dPtr New(Args&&... args) {
    return Vector2dPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vector2dPtr From(const U& u) {
    return mojo::TypeConverter<Vector2dPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vector2d>::Convert(*this);
  }


  Vector2d();

  Vector2d(
      int32_t x,
      int32_t y);


  ~Vector2d();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vector2dPtr>
  Vector2dPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vector2d::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vector2d::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vector2d::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vector2d_UnserializedMessageContext<
            UserType, Vector2d::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Vector2d::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Vector2d::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vector2d_UnserializedMessageContext<
            UserType, Vector2d::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vector2d::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t x;
  
  int32_t y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vector2d::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Vector2dF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vector2dF, T>::value>;
  using DataView = Vector2dFDataView;
  using Data_ = internal::Vector2dF_Data;

  template <typename... Args>
  static Vector2dFPtr New(Args&&... args) {
    return Vector2dFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vector2dFPtr From(const U& u) {
    return mojo::TypeConverter<Vector2dFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vector2dF>::Convert(*this);
  }


  Vector2dF();

  Vector2dF(
      float x,
      float y);


  ~Vector2dF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vector2dFPtr>
  Vector2dFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vector2dF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vector2dF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vector2dF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vector2dF_UnserializedMessageContext<
            UserType, Vector2dF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Vector2dF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Vector2dF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vector2dF_UnserializedMessageContext<
            UserType, Vector2dF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vector2dF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vector2dF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Vector3dF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Vector3dF, T>::value>;
  using DataView = Vector3dFDataView;
  using Data_ = internal::Vector3dF_Data;

  template <typename... Args>
  static Vector3dFPtr New(Args&&... args) {
    return Vector3dFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static Vector3dFPtr From(const U& u) {
    return mojo::TypeConverter<Vector3dFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Vector3dF>::Convert(*this);
  }


  Vector3dF();

  Vector3dF(
      float x,
      float y,
      float z);


  ~Vector3dF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = Vector3dFPtr>
  Vector3dFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vector3dF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Vector3dF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Vector3dF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Vector3dF_UnserializedMessageContext<
            UserType, Vector3dF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Vector3dF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Vector3dF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Vector3dF_UnserializedMessageContext<
            UserType, Vector3dF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Vector3dF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float y;
  
  float z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Vector3dF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Quaternion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Quaternion, T>::value>;
  using DataView = QuaternionDataView;
  using Data_ = internal::Quaternion_Data;

  template <typename... Args>
  static QuaternionPtr New(Args&&... args) {
    return QuaternionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QuaternionPtr From(const U& u) {
    return mojo::TypeConverter<QuaternionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Quaternion>::Convert(*this);
  }


  Quaternion();

  Quaternion(
      double x,
      double y,
      double z,
      double w);


  ~Quaternion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QuaternionPtr>
  QuaternionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Quaternion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Quaternion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Quaternion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Quaternion_UnserializedMessageContext<
            UserType, Quaternion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Quaternion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Quaternion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Quaternion_UnserializedMessageContext<
            UserType, Quaternion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Quaternion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double x;
  
  double y;
  
  double z;
  
  double w;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Quaternion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





















class  QuadF {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QuadF, T>::value>;
  using DataView = QuadFDataView;
  using Data_ = internal::QuadF_Data;

  template <typename... Args>
  static QuadFPtr New(Args&&... args) {
    return QuadFPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QuadFPtr From(const U& u) {
    return mojo::TypeConverter<QuadFPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QuadF>::Convert(*this);
  }


  QuadF();

  QuadF(
      const ::gfx::PointF& p1,
      const ::gfx::PointF& p2,
      const ::gfx::PointF& p3,
      const ::gfx::PointF& p4);


  ~QuadF();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QuadFPtr>
  QuadFPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QuadF::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QuadF::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QuadF::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuadF::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuadF::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QuadF::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QuadF_UnserializedMessageContext<
            UserType, QuadF::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QuadF::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QuadF::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QuadF_UnserializedMessageContext<
            UserType, QuadF::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QuadF::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF p1;
  
  ::gfx::PointF p2;
  
  ::gfx::PointF p3;
  
  ::gfx::PointF p4;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QuadF::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QuadF::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QuadF::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QuadF::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PointPtr Point::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, Point::EnableIfSame<T>*>
bool Point::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, Point::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}
template <typename StructPtrType>
PointFPtr PointF::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, PointF::EnableIfSame<T>*>
bool PointF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, PointF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}
template <typename StructPtrType>
Point3FPtr Point3F::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(z)
  );
}

template <typename T, Point3F::EnableIfSame<T>*>
bool Point3F::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  return true;
}

template <typename T, Point3F::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  return false;
}
template <typename StructPtrType>
SizePtr Size::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, Size::EnableIfSame<T>*>
bool Size::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, Size::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}
template <typename StructPtrType>
SizeFPtr SizeF::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, SizeF::EnableIfSame<T>*>
bool SizeF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, SizeF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}
template <typename StructPtrType>
RectPtr Rect::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, Rect::EnableIfSame<T>*>
bool Rect::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, Rect::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}
template <typename StructPtrType>
RectFPtr RectF::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, RectF::EnableIfSame<T>*>
bool RectF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, RectF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}
template <typename StructPtrType>
InsetsPtr Insets::Clone() const {
  return New(
      mojo::Clone(top),
      mojo::Clone(left),
      mojo::Clone(bottom),
      mojo::Clone(right)
  );
}

template <typename T, Insets::EnableIfSame<T>*>
bool Insets::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top, other_struct.top))
    return false;
  if (!mojo::Equals(this->left, other_struct.left))
    return false;
  if (!mojo::Equals(this->bottom, other_struct.bottom))
    return false;
  if (!mojo::Equals(this->right, other_struct.right))
    return false;
  return true;
}

template <typename T, Insets::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top < rhs.top)
    return true;
  if (rhs.top < lhs.top)
    return false;
  if (lhs.left < rhs.left)
    return true;
  if (rhs.left < lhs.left)
    return false;
  if (lhs.bottom < rhs.bottom)
    return true;
  if (rhs.bottom < lhs.bottom)
    return false;
  if (lhs.right < rhs.right)
    return true;
  if (rhs.right < lhs.right)
    return false;
  return false;
}
template <typename StructPtrType>
InsetsFPtr InsetsF::Clone() const {
  return New(
      mojo::Clone(top),
      mojo::Clone(left),
      mojo::Clone(bottom),
      mojo::Clone(right)
  );
}

template <typename T, InsetsF::EnableIfSame<T>*>
bool InsetsF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top, other_struct.top))
    return false;
  if (!mojo::Equals(this->left, other_struct.left))
    return false;
  if (!mojo::Equals(this->bottom, other_struct.bottom))
    return false;
  if (!mojo::Equals(this->right, other_struct.right))
    return false;
  return true;
}

template <typename T, InsetsF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top < rhs.top)
    return true;
  if (rhs.top < lhs.top)
    return false;
  if (lhs.left < rhs.left)
    return true;
  if (rhs.left < lhs.left)
    return false;
  if (lhs.bottom < rhs.bottom)
    return true;
  if (rhs.bottom < lhs.bottom)
    return false;
  if (lhs.right < rhs.right)
    return true;
  if (rhs.right < lhs.right)
    return false;
  return false;
}
template <typename StructPtrType>
Vector2dPtr Vector2d::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, Vector2d::EnableIfSame<T>*>
bool Vector2d::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, Vector2d::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}
template <typename StructPtrType>
Vector2dFPtr Vector2dF::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y)
  );
}

template <typename T, Vector2dF::EnableIfSame<T>*>
bool Vector2dF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  return true;
}

template <typename T, Vector2dF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  return false;
}
template <typename StructPtrType>
Vector3dFPtr Vector3dF::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(z)
  );
}

template <typename T, Vector3dF::EnableIfSame<T>*>
bool Vector3dF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  return true;
}

template <typename T, Vector3dF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  return false;
}
template <typename StructPtrType>
QuaternionPtr Quaternion::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(z),
      mojo::Clone(w)
  );
}

template <typename T, Quaternion::EnableIfSame<T>*>
bool Quaternion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  if (!mojo::Equals(this->w, other_struct.w))
    return false;
  return true;
}

template <typename T, Quaternion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  if (lhs.w < rhs.w)
    return true;
  if (rhs.w < lhs.w)
    return false;
  return false;
}
template <typename StructPtrType>
QuadFPtr QuadF::Clone() const {
  return New(
      mojo::Clone(p1),
      mojo::Clone(p2),
      mojo::Clone(p3),
      mojo::Clone(p4)
  );
}

template <typename T, QuadF::EnableIfSame<T>*>
bool QuadF::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->p1, other_struct.p1))
    return false;
  if (!mojo::Equals(this->p2, other_struct.p2))
    return false;
  if (!mojo::Equals(this->p3, other_struct.p3))
    return false;
  if (!mojo::Equals(this->p4, other_struct.p4))
    return false;
  return true;
}

template <typename T, QuadF::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.p1 < rhs.p1)
    return true;
  if (rhs.p1 < lhs.p1)
    return false;
  if (lhs.p2 < rhs.p2)
    return true;
  if (rhs.p2 < lhs.p2)
    return false;
  if (lhs.p3 < rhs.p3)
    return true;
  if (rhs.p3 < lhs.p3)
    return false;
  if (lhs.p4 < rhs.p4)
    return true;
  if (rhs.p4 < lhs.p4)
    return false;
  return false;
}


}  // gfx::mojom

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::Point::DataView,
                                         ::gfx::mojom::PointPtr> {
  static bool IsNull(const ::gfx::mojom::PointPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::PointPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Point::x) x(
      const ::gfx::mojom::PointPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Point::y) y(
      const ::gfx::mojom::PointPtr& input) {
    return input->y;
  }

  static bool Read(::gfx::mojom::Point::DataView input, ::gfx::mojom::PointPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::PointF::DataView,
                                         ::gfx::mojom::PointFPtr> {
  static bool IsNull(const ::gfx::mojom::PointFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::PointFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::PointF::x) x(
      const ::gfx::mojom::PointFPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::PointF::y) y(
      const ::gfx::mojom::PointFPtr& input) {
    return input->y;
  }

  static bool Read(::gfx::mojom::PointF::DataView input, ::gfx::mojom::PointFPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Point3F::DataView,
                                         ::gfx::mojom::Point3FPtr> {
  static bool IsNull(const ::gfx::mojom::Point3FPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::Point3FPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Point3F::x) x(
      const ::gfx::mojom::Point3FPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Point3F::y) y(
      const ::gfx::mojom::Point3FPtr& input) {
    return input->y;
  }

  static decltype(::gfx::mojom::Point3F::z) z(
      const ::gfx::mojom::Point3FPtr& input) {
    return input->z;
  }

  static bool Read(::gfx::mojom::Point3F::DataView input, ::gfx::mojom::Point3FPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Size::DataView,
                                         ::gfx::mojom::SizePtr> {
  static bool IsNull(const ::gfx::mojom::SizePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::SizePtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Size::width) width(
      const ::gfx::mojom::SizePtr& input) {
    return input->width;
  }

  static decltype(::gfx::mojom::Size::height) height(
      const ::gfx::mojom::SizePtr& input) {
    return input->height;
  }

  static bool Read(::gfx::mojom::Size::DataView input, ::gfx::mojom::SizePtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::SizeF::DataView,
                                         ::gfx::mojom::SizeFPtr> {
  static bool IsNull(const ::gfx::mojom::SizeFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::SizeFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::SizeF::width) width(
      const ::gfx::mojom::SizeFPtr& input) {
    return input->width;
  }

  static decltype(::gfx::mojom::SizeF::height) height(
      const ::gfx::mojom::SizeFPtr& input) {
    return input->height;
  }

  static bool Read(::gfx::mojom::SizeF::DataView input, ::gfx::mojom::SizeFPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Rect::DataView,
                                         ::gfx::mojom::RectPtr> {
  static bool IsNull(const ::gfx::mojom::RectPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::RectPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Rect::x) x(
      const ::gfx::mojom::RectPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Rect::y) y(
      const ::gfx::mojom::RectPtr& input) {
    return input->y;
  }

  static decltype(::gfx::mojom::Rect::width) width(
      const ::gfx::mojom::RectPtr& input) {
    return input->width;
  }

  static decltype(::gfx::mojom::Rect::height) height(
      const ::gfx::mojom::RectPtr& input) {
    return input->height;
  }

  static bool Read(::gfx::mojom::Rect::DataView input, ::gfx::mojom::RectPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::RectF::DataView,
                                         ::gfx::mojom::RectFPtr> {
  static bool IsNull(const ::gfx::mojom::RectFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::RectFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::RectF::x) x(
      const ::gfx::mojom::RectFPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::RectF::y) y(
      const ::gfx::mojom::RectFPtr& input) {
    return input->y;
  }

  static decltype(::gfx::mojom::RectF::width) width(
      const ::gfx::mojom::RectFPtr& input) {
    return input->width;
  }

  static decltype(::gfx::mojom::RectF::height) height(
      const ::gfx::mojom::RectFPtr& input) {
    return input->height;
  }

  static bool Read(::gfx::mojom::RectF::DataView input, ::gfx::mojom::RectFPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Insets::DataView,
                                         ::gfx::mojom::InsetsPtr> {
  static bool IsNull(const ::gfx::mojom::InsetsPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::InsetsPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Insets::top) top(
      const ::gfx::mojom::InsetsPtr& input) {
    return input->top;
  }

  static decltype(::gfx::mojom::Insets::left) left(
      const ::gfx::mojom::InsetsPtr& input) {
    return input->left;
  }

  static decltype(::gfx::mojom::Insets::bottom) bottom(
      const ::gfx::mojom::InsetsPtr& input) {
    return input->bottom;
  }

  static decltype(::gfx::mojom::Insets::right) right(
      const ::gfx::mojom::InsetsPtr& input) {
    return input->right;
  }

  static bool Read(::gfx::mojom::Insets::DataView input, ::gfx::mojom::InsetsPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::InsetsF::DataView,
                                         ::gfx::mojom::InsetsFPtr> {
  static bool IsNull(const ::gfx::mojom::InsetsFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::InsetsFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::InsetsF::top) top(
      const ::gfx::mojom::InsetsFPtr& input) {
    return input->top;
  }

  static decltype(::gfx::mojom::InsetsF::left) left(
      const ::gfx::mojom::InsetsFPtr& input) {
    return input->left;
  }

  static decltype(::gfx::mojom::InsetsF::bottom) bottom(
      const ::gfx::mojom::InsetsFPtr& input) {
    return input->bottom;
  }

  static decltype(::gfx::mojom::InsetsF::right) right(
      const ::gfx::mojom::InsetsFPtr& input) {
    return input->right;
  }

  static bool Read(::gfx::mojom::InsetsF::DataView input, ::gfx::mojom::InsetsFPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Vector2d::DataView,
                                         ::gfx::mojom::Vector2dPtr> {
  static bool IsNull(const ::gfx::mojom::Vector2dPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::Vector2dPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Vector2d::x) x(
      const ::gfx::mojom::Vector2dPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Vector2d::y) y(
      const ::gfx::mojom::Vector2dPtr& input) {
    return input->y;
  }

  static bool Read(::gfx::mojom::Vector2d::DataView input, ::gfx::mojom::Vector2dPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Vector2dF::DataView,
                                         ::gfx::mojom::Vector2dFPtr> {
  static bool IsNull(const ::gfx::mojom::Vector2dFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::Vector2dFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Vector2dF::x) x(
      const ::gfx::mojom::Vector2dFPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Vector2dF::y) y(
      const ::gfx::mojom::Vector2dFPtr& input) {
    return input->y;
  }

  static bool Read(::gfx::mojom::Vector2dF::DataView input, ::gfx::mojom::Vector2dFPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Vector3dF::DataView,
                                         ::gfx::mojom::Vector3dFPtr> {
  static bool IsNull(const ::gfx::mojom::Vector3dFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::Vector3dFPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Vector3dF::x) x(
      const ::gfx::mojom::Vector3dFPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Vector3dF::y) y(
      const ::gfx::mojom::Vector3dFPtr& input) {
    return input->y;
  }

  static decltype(::gfx::mojom::Vector3dF::z) z(
      const ::gfx::mojom::Vector3dFPtr& input) {
    return input->z;
  }

  static bool Read(::gfx::mojom::Vector3dF::DataView input, ::gfx::mojom::Vector3dFPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::Quaternion::DataView,
                                         ::gfx::mojom::QuaternionPtr> {
  static bool IsNull(const ::gfx::mojom::QuaternionPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::QuaternionPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::Quaternion::x) x(
      const ::gfx::mojom::QuaternionPtr& input) {
    return input->x;
  }

  static decltype(::gfx::mojom::Quaternion::y) y(
      const ::gfx::mojom::QuaternionPtr& input) {
    return input->y;
  }

  static decltype(::gfx::mojom::Quaternion::z) z(
      const ::gfx::mojom::QuaternionPtr& input) {
    return input->z;
  }

  static decltype(::gfx::mojom::Quaternion::w) w(
      const ::gfx::mojom::QuaternionPtr& input) {
    return input->w;
  }

  static bool Read(::gfx::mojom::Quaternion::DataView input, ::gfx::mojom::QuaternionPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::QuadF::DataView,
                                         ::gfx::mojom::QuadFPtr> {
  static bool IsNull(const ::gfx::mojom::QuadFPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::QuadFPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::QuadF::p1)& p1(
      const ::gfx::mojom::QuadFPtr& input) {
    return input->p1;
  }

  static const decltype(::gfx::mojom::QuadF::p2)& p2(
      const ::gfx::mojom::QuadFPtr& input) {
    return input->p2;
  }

  static const decltype(::gfx::mojom::QuadF::p3)& p3(
      const ::gfx::mojom::QuadFPtr& input) {
    return input->p3;
  }

  static const decltype(::gfx::mojom::QuadF::p4)& p4(
      const ::gfx::mojom::QuadFPtr& input) {
    return input->p4;
  }

  static bool Read(::gfx::mojom::QuadF::DataView input, ::gfx::mojom::QuadFPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_GEOMETRY_MOJOM_GEOMETRY_MOJOM_H_