// ui/events/mojom/event.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/events/mojom/event.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/events/mojom/event.mojom-params-data.h"
namespace ui {
namespace mojom {

namespace internal {
// static
bool GestureDataDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GestureDataDetails_Data* object = static_cast<const GestureDataDetails_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GestureDataDetails_Tag::kPinch: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_pinch, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_pinch, validation_context))
        return false;
      return true;
    }
    case GestureDataDetails_Tag::kSwipe: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_swipe, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_swipe, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GestureDataDetails");
      return false;
    }
  }
}


// static
bool KeyData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const KeyData_Data* object =
      static_cast<const KeyData_Data*>(data);

  return true;
}

KeyData_Data::KeyData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LocationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LocationData_Data* object =
      static_cast<const LocationData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relative_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->root_location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->root_location, validation_context))
    return false;

  return true;
}

LocationData_Data::LocationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GesturePinchData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GesturePinchData_Data* object =
      static_cast<const GesturePinchData_Data*>(data);

  return true;
}

GesturePinchData_Data::GesturePinchData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GestureSwipeData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GestureSwipeData_Data* object =
      static_cast<const GestureSwipeData_Data*>(data);

  return true;
}

GestureSwipeData_Data::GestureSwipeData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GestureData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GestureData_Data* object =
      static_cast<const GestureData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::ui::mojom::internal::GestureDeviceType_Data
        ::Validate(object->device_type, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->details, validation_context))
    return false;

  return true;
}

GestureData_Data::GestureData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollData_Data* object =
      static_cast<const ScrollData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;


  if (!::ui::mojom::internal::EventMomentumPhase_Data
        ::Validate(object->momentum_phase, validation_context))
    return false;


  if (!::ui::mojom::internal::ScrollEventPhase_Data
        ::Validate(object->scroll_event_phase, validation_context))
    return false;

  return true;
}

ScrollData_Data::ScrollData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PointerDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PointerDetails_Data* object =
      static_cast<const PointerDetails_Data*>(data);


  if (!::ui::mojom::internal::EventPointerType_Data
        ::Validate(object->pointer_type, validation_context))
    return false;

  return true;
}

PointerDetails_Data::PointerDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MouseData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MouseData_Data* object =
      static_cast<const MouseData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointer_details, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pointer_details, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->wheel_offset, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->wheel_offset, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tick_120ths, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tick_120ths, validation_context))
    return false;

  return true;
}

MouseData_Data::MouseData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TouchData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TouchData_Data* object =
      static_cast<const TouchData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pointer_details, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pointer_details, validation_context))
    return false;

  return true;
}

TouchData_Data::TouchData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Event_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Event_Data* object =
      static_cast<const Event_Data*>(data);


  if (!::ui::mojom::internal::EventType_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_stamp, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_stamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latency, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->latency, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->key_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->gesture_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->scroll_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->touch_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mouse_data, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& properties_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->properties, validation_context,
                                         &properties_validate_params)) {
    return false;
  }

  return true;
}

Event_Data::Event_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace ui