// ui/events/mojom/event.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_MOJOM_EVENT_MOJOM_DATA_VIEW_H_
#define UI_EVENTS_MOJOM_EVENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/events/mojom/event.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/latency/mojom/latency_info.mojom-shared.h"


namespace ui::mojom {
class KeyDataDataView;

class LocationDataDataView;

class GesturePinchDataDataView;

class GestureSwipeDataDataView;

class GestureDataDataView;

class ScrollDataDataView;

class PointerDetailsDataView;

class MouseDataDataView;

class TouchDataDataView;

class EventDataView;

class GestureDataDetailsDataView;


}  // ui::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::KeyDataDataView> {
  using Data = ::ui::mojom::internal::KeyData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::LocationDataDataView> {
  using Data = ::ui::mojom::internal::LocationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GesturePinchDataDataView> {
  using Data = ::ui::mojom::internal::GesturePinchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GestureSwipeDataDataView> {
  using Data = ::ui::mojom::internal::GestureSwipeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GestureDataDataView> {
  using Data = ::ui::mojom::internal::GestureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::ScrollDataDataView> {
  using Data = ::ui::mojom::internal::ScrollData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::PointerDetailsDataView> {
  using Data = ::ui::mojom::internal::PointerDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::MouseDataDataView> {
  using Data = ::ui::mojom::internal::MouseData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::TouchDataDataView> {
  using Data = ::ui::mojom::internal::TouchData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::EventDataView> {
  using Data = ::ui::mojom::internal::Event_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ui::mojom::GestureDataDetailsDataView> {
  using Data = ::ui::mojom::internal::GestureDataDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


class KeyDataDataView {
 public:
  KeyDataDataView() = default;

  KeyDataDataView(
      internal::KeyData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t key_code() const {
    return data_->key_code;
  }
  uint32_t dom_code() const {
    return data_->dom_code;
  }
  int32_t dom_key() const {
    return data_->dom_key;
  }
  bool is_char() const {
    return data_->is_char;
  }
 private:
  internal::KeyData_Data* data_ = nullptr;
};


class LocationDataDataView {
 public:
  LocationDataDataView() = default;

  LocationDataDataView(
      internal::LocationData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRelativeLocationDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeLocation(UserType* output) {
    
    auto* pointer = data_->relative_location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetRootLocationDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootLocation(UserType* output) {
    
    auto* pointer = data_->root_location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
 private:
  internal::LocationData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GesturePinchDataDataView {
 public:
  GesturePinchDataDataView() = default;

  GesturePinchDataDataView(
      internal::GesturePinchData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float scale() const {
    return data_->scale;
  }
 private:
  internal::GesturePinchData_Data* data_ = nullptr;
};


class GestureSwipeDataDataView {
 public:
  GestureSwipeDataDataView() = default;

  GestureSwipeDataDataView(
      internal::GestureSwipeData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool left() const {
    return data_->left;
  }
  bool right() const {
    return data_->right;
  }
  bool up() const {
    return data_->up;
  }
  bool down() const {
    return data_->down;
  }
 private:
  internal::GestureSwipeData_Data* data_ = nullptr;
};


class GestureDataDataView {
 public:
  GestureDataDataView() = default;

  GestureDataDataView(
      internal::GestureData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeviceType(UserType* output) const {
    auto data_value = data_->device_type;
    return mojo::internal::Deserialize<::ui::mojom::GestureDeviceType>(
        data_value, output);
  }
  ::ui::mojom::GestureDeviceType device_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::GestureDeviceType>(data_->device_type));
  }
  inline void GetDetailsDataView(
      GestureDataDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::GestureDataDetailsDataView, UserType>(),
    "Attempting to read the optional `details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetails` instead "
    "of `ReadDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->details.is_null() ? &data_->details : nullptr;
    return mojo::internal::Deserialize<::ui::mojom::GestureDataDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::GestureData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ScrollDataDataView {
 public:
  ScrollDataDataView() = default;

  ScrollDataDataView(
      internal::ScrollData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  float x_offset() const {
    return data_->x_offset;
  }
  float y_offset() const {
    return data_->y_offset;
  }
  float x_offset_ordinal() const {
    return data_->x_offset_ordinal;
  }
  float y_offset_ordinal() const {
    return data_->y_offset_ordinal;
  }
  int32_t finger_count() const {
    return data_->finger_count;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMomentumPhase(UserType* output) const {
    auto data_value = data_->momentum_phase;
    return mojo::internal::Deserialize<::ui::mojom::EventMomentumPhase>(
        data_value, output);
  }
  ::ui::mojom::EventMomentumPhase momentum_phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventMomentumPhase>(data_->momentum_phase));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollEventPhase(UserType* output) const {
    auto data_value = data_->scroll_event_phase;
    return mojo::internal::Deserialize<::ui::mojom::ScrollEventPhase>(
        data_value, output);
  }
  ::ui::mojom::ScrollEventPhase scroll_event_phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::ScrollEventPhase>(data_->scroll_event_phase));
  }
 private:
  internal::ScrollData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PointerDetailsDataView {
 public:
  PointerDetailsDataView() = default;

  PointerDetailsDataView(
      internal::PointerDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPointerType(UserType* output) const {
    auto data_value = data_->pointer_type;
    return mojo::internal::Deserialize<::ui::mojom::EventPointerType>(
        data_value, output);
  }
  ::ui::mojom::EventPointerType pointer_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventPointerType>(data_->pointer_type));
  }
  float radius_x() const {
    return data_->radius_x;
  }
  float radius_y() const {
    return data_->radius_y;
  }
  float force() const {
    return data_->force;
  }
  float tilt_x() const {
    return data_->tilt_x;
  }
  float tilt_y() const {
    return data_->tilt_y;
  }
  float tangential_pressure() const {
    return data_->tangential_pressure;
  }
  float twist() const {
    return data_->twist;
  }
  int32_t id() const {
    return data_->id;
  }
  int32_t offset_x() const {
    return data_->offset_x;
  }
  int32_t offset_y() const {
    return data_->offset_y;
  }
 private:
  internal::PointerDetails_Data* data_ = nullptr;
};


class MouseDataDataView {
 public:
  MouseDataDataView() = default;

  MouseDataDataView(
      internal::MouseData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t changed_button_flags() const {
    return data_->changed_button_flags;
  }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  inline void GetPointerDetailsDataView(
      PointerDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerDetails(UserType* output) {
    
    auto* pointer = data_->pointer_details.Get();
    return mojo::internal::Deserialize<::ui::mojom::PointerDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetWheelOffsetDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWheelOffset(UserType* output) {
    
    auto* pointer = data_->wheel_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetTick120thsDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTick120ths(UserType* output) {
    
    auto* pointer = data_->tick_120ths.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
 private:
  internal::MouseData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TouchDataDataView {
 public:
  TouchDataDataView() = default;

  TouchDataDataView(
      internal::TouchData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool may_cause_scrolling() const {
    return data_->may_cause_scrolling;
  }
  bool hovering() const {
    return data_->hovering;
  }
  inline void GetLocationDataView(
      LocationDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::ui::mojom::LocationDataDataView>(
        pointer, output, message_);
  }
  inline void GetPointerDetailsDataView(
      PointerDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointerDetails(UserType* output) {
    
    auto* pointer = data_->pointer_details.Get();
    return mojo::internal::Deserialize<::ui::mojom::PointerDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::TouchData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventDataView {
 public:
  EventDataView() = default;

  EventDataView(
      internal::Event_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::ui::mojom::EventType>(
        data_value, output);
  }
  ::ui::mojom::EventType action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::EventType>(data_->action));
  }
  int32_t flags() const {
    return data_->flags;
  }
  inline void GetTimeStampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeStamp(UserType* output) {
    
    auto* pointer = data_->time_stamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetLatencyDataView(
      ::ui::mojom::LatencyInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::ui::mojom::LatencyInfoDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataDataView(
      KeyDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::KeyDataDataView, UserType>(),
    "Attempting to read the optional `key_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyData` instead "
    "of `ReadKeyData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::KeyDataDataView>(
        pointer, output, message_);
  }
  inline void GetGestureDataDataView(
      GestureDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGestureData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::GestureDataDataView, UserType>(),
    "Attempting to read the optional `gesture_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGestureData` instead "
    "of `ReadGestureData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gesture_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::GestureDataDataView>(
        pointer, output, message_);
  }
  inline void GetScrollDataDataView(
      ScrollDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::ScrollDataDataView, UserType>(),
    "Attempting to read the optional `scroll_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollData` instead "
    "of `ReadScrollData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroll_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::ScrollDataDataView>(
        pointer, output, message_);
  }
  inline void GetTouchDataDataView(
      TouchDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTouchData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::TouchDataDataView, UserType>(),
    "Attempting to read the optional `touch_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTouchData` instead "
    "of `ReadTouchData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->touch_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::TouchDataDataView>(
        pointer, output, message_);
  }
  inline void GetMouseDataDataView(
      MouseDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMouseData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ui::mojom::MouseDataDataView, UserType>(),
    "Attempting to read the optional `mouse_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMouseData` instead "
    "of `ReadMouseData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mouse_data.Get();
    return mojo::internal::Deserialize<::ui::mojom::MouseDataDataView>(
        pointer, output, message_);
  }
  inline void GetPropertiesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProperties(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>, UserType>(),
    "Attempting to read the optional `properties` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProperties` instead "
    "of `ReadProperties if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::Event_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GestureDataDetailsDataView {
 public:
  using Tag = internal::GestureDataDetails_Data::GestureDataDetails_Tag;

  GestureDataDetailsDataView() = default;

  GestureDataDetailsDataView(
      internal::GestureDataDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_pinch() const { return data_->tag == Tag::kPinch; }
  inline void GetPinchDataView(
      GesturePinchDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPinch(UserType* output) const {
    
    CHECK(is_pinch());
    return mojo::internal::Deserialize<::ui::mojom::GesturePinchDataDataView>(
        data_->data.f_pinch.Get(), output, message_);
  }
  bool is_swipe() const { return data_->tag == Tag::kSwipe; }
  inline void GetSwipeDataView(
      GestureSwipeDataDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSwipe(UserType* output) const {
    
    CHECK(is_swipe());
    return mojo::internal::Deserialize<::ui::mojom::GestureSwipeDataDataView>(
        data_->data.f_swipe.Get(), output, message_);
  }

 private:
  internal::GestureDataDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // ui::mojom

#endif  // UI_EVENTS_MOJOM_EVENT_MOJOM_DATA_VIEW_H_