// ui/display/mojom/display_layout.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_SEND_VALIDATION_H_
#define UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_SEND_VALIDATION_H_

#include "ui/display/mojom/display_layout.mojom-shared-internal.h"

#include "ui/display/mojom/display_layout.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::display::mojom::Position, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::display::mojom::OffsetReference, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::DisplayPlacementDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayPlacementDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplayPlacement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->display_id = Traits::display_id(input);

      fragment->parent_display_id = Traits::parent_display_id(input);

      
      mojo::internal::Serialize<::display::mojom::Position>(
        Traits::position(input),
        &fragment->position);

      fragment->offset = Traits::offset(input);

      
      mojo::internal::Serialize<::display::mojom::OffsetReference>(
        Traits::offset_reference(input),
        &fragment->offset_reference);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::DisplayLayoutDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayLayoutDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::DisplayLayout_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->default_unified = Traits::default_unified(input);

      fragment->primary_display_id = Traits::primary_display_id(input);

      decltype(Traits::placement_list(input)) in_placement_list = Traits::placement_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->placement_list)::BaseType>
          placement_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& placement_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::display::mojom::DisplayPlacementDataView>, send_validation>(
        in_placement_list,
        placement_list_fragment,
        &placement_list_validate_params);

      fragment->placement_list.Set(
          placement_list_fragment.is_null() ? nullptr : placement_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->placement_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null placement_list in DisplayLayout struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_DISPLAY_MOJOM_DISPLAY_LAYOUT_MOJOM_SEND_VALIDATION_H_