// ui/display/mojom/display.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_MOJOM_SHARED_H_
#define UI_DISPLAY_MOJOM_DISPLAY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"




#include "ui/display/mojom/display.mojom-data-view.h"




namespace std {

template <>
struct hash<::display::mojom::Rotation>
    : public mojo::internal::EnumHashImpl<::display::mojom::Rotation> {};

template <>
struct hash<::display::mojom::TouchSupport>
    : public mojo::internal::EnumHashImpl<::display::mojom::TouchSupport> {};

template <>
struct hash<::display::mojom::AccelerometerSupport>
    : public mojo::internal::EnumHashImpl<::display::mojom::AccelerometerSupport> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::Rotation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::Rotation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::Rotation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::TouchSupport, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::TouchSupport, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::TouchSupport>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::AccelerometerSupport, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::display::mojom::AccelerometerSupport, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::display::mojom::AccelerometerSupport>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::display::mojom::DisplayDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::Display_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds,
      bounds_fragment);

    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in Display struct");

    decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size_in_pixels,
      size_in_pixels_fragment);

    fragment->size_in_pixels.Set(
        size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size_in_pixels.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size_in_pixels in Display struct");

    decltype(Traits::native_origin(input)) in_native_origin = Traits::native_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->native_origin)::BaseType> native_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_native_origin,
      native_origin_fragment);

    fragment->native_origin.Set(
        native_origin_fragment.is_null() ? nullptr : native_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->native_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null native_origin in Display struct");

    decltype(Traits::work_area(input)) in_work_area = Traits::work_area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->work_area)::BaseType> work_area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_work_area,
      work_area_fragment);

    fragment->work_area.Set(
        work_area_fragment.is_null() ? nullptr : work_area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->work_area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null work_area in Display struct");

    fragment->device_scale_factor = Traits::device_scale_factor(input);

    
    mojo::internal::Serialize<::display::mojom::Rotation>(
      Traits::rotation(input),
      &fragment->rotation);

    
    mojo::internal::Serialize<::display::mojom::TouchSupport>(
      Traits::touch_support(input),
      &fragment->touch_support);

    
    mojo::internal::Serialize<::display::mojom::AccelerometerSupport>(
      Traits::accelerometer_support(input),
      &fragment->accelerometer_support);

    decltype(Traits::maximum_cursor_size(input)) in_maximum_cursor_size = Traits::maximum_cursor_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maximum_cursor_size)::BaseType> maximum_cursor_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_maximum_cursor_size,
      maximum_cursor_size_fragment);

    fragment->maximum_cursor_size.Set(
        maximum_cursor_size_fragment.is_null() ? nullptr : maximum_cursor_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->maximum_cursor_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null maximum_cursor_size in Display struct");

    decltype(Traits::color_spaces(input)) in_color_spaces = Traits::color_spaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_spaces)::BaseType> color_spaces_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
      in_color_spaces,
      color_spaces_fragment);

    fragment->color_spaces.Set(
        color_spaces_fragment.is_null() ? nullptr : color_spaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->color_spaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null color_spaces in Display struct");

    fragment->color_depth = Traits::color_depth(input);

    fragment->depth_per_component = Traits::depth_per_component(input);

    fragment->is_monochrome = Traits::is_monochrome(input);

    fragment->display_frequency = Traits::display_frequency(input);

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Display struct");
  }

  static bool Deserialize(::display::mojom::internal::Display_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::display::mojom::DisplayDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace display::mojom {

inline void DisplayDataView::GetBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void DisplayDataView::GetSizeInPixelsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size_in_pixels.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void DisplayDataView::GetNativeOriginDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->native_origin.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void DisplayDataView::GetWorkAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->work_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void DisplayDataView::GetMaximumCursorSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->maximum_cursor_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void DisplayDataView::GetColorSpacesDataView(
    ::gfx::mojom::DisplayColorSpacesDataView* output) {
  auto pointer = data_->color_spaces.Get();
  *output = ::gfx::mojom::DisplayColorSpacesDataView(pointer, message_);
}
inline void DisplayDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // display::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::Rotation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::Rotation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::TouchSupport> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::TouchSupport value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::display::mojom::AccelerometerSupport> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::display::mojom::AccelerometerSupport value);
};

} // namespace perfetto

#endif  // UI_DISPLAY_MOJOM_DISPLAY_MOJOM_SHARED_H_