// ui/base/mojom/menu_source_type.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/base/mojom/menu_source_type.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/mojom/menu_source_type.mojom-params-data.h"
namespace ui {
namespace mojom {

NOINLINE static const char* MenuSourceTypeToStringHelper(MenuSourceType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MenuSourceType::kNone:
      return "kNone";
    case MenuSourceType::kMouse:
      return "kMouse";
    case MenuSourceType::kKeyboard:
      return "kKeyboard";
    case MenuSourceType::kTouch:
      return "kTouch";
    case MenuSourceType::kTouchEditMenu:
      return "kTouchEditMenu";
    case MenuSourceType::kLongPress:
      return "kLongPress";
    case MenuSourceType::kLongTap:
      return "kLongTap";
    case MenuSourceType::kTouchHandle:
      return "kTouchHandle";
    case MenuSourceType::kStylus:
      return "kStylus";
    case MenuSourceType::kAdjustSelection:
      return "kAdjustSelection";
    case MenuSourceType::kAdjustSelectionReset:
      return "kAdjustSelectionReset";
    default:
      return nullptr;
  }
}

std::string MenuSourceTypeToString(MenuSourceType value) {
  const char *str = MenuSourceTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MenuSourceType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MenuSourceType value) {
  return os << MenuSourceTypeToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace ui

namespace perfetto {

// static
void TraceFormatTraits<::ui::mojom::MenuSourceType>::WriteIntoTrace(
   perfetto::TracedValue context, ::ui::mojom::MenuSourceType value) {
  return std::move(context).WriteString(::ui::mojom::MenuSourceTypeToString(value));
}

} // namespace perfetto