// ui/accessibility/mojom/ax_updates_and_events.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"




#include "ui/accessibility/mojom/ax_updates_and_events.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXUpdatesAndEventsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXUpdatesAndEventsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXUpdatesAndEvents_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tree_id(input)) in_tree_id = Traits::tree_id(input);
    mojo::internal::MessageFragment<decltype(fragment->tree_id)>
        tree_id_fragment(fragment.message());
    tree_id_fragment.Claim(&fragment->tree_id);
    
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
      in_tree_id,
      tree_id_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tree_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tree_id in AXUpdatesAndEvents struct");

    decltype(Traits::updates(input)) in_updates = Traits::updates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updates)::BaseType>
        updates_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& updates_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>>(
      in_updates,
      updates_fragment,
      &updates_validate_params);

    fragment->updates.Set(
        updates_fragment.is_null() ? nullptr : updates_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->updates.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updates in AXUpdatesAndEvents struct");

    decltype(Traits::events(input)) in_events = Traits::events(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->events)::BaseType>
        events_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXEventDataView>>(
      in_events,
      events_fragment,
      &events_validate_params);

    fragment->events.Set(
        events_fragment.is_null() ? nullptr : events_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->events.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null events in AXUpdatesAndEvents struct");
  }

  static bool Deserialize(::ax::mojom::internal::AXUpdatesAndEvents_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXUpdatesAndEventsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {

inline void AXUpdatesAndEventsDataView::GetTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, message_);
}
inline void AXUpdatesAndEventsDataView::GetUpdatesDataView(
    mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>* output) {
  auto pointer = data_->updates.Get();
  *output = mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>(pointer, message_);
}
inline void AXUpdatesAndEventsDataView::GetEventsDataView(
    mojo::ArrayDataView<::ax::mojom::AXEventDataView>* output) {
  auto pointer = data_->events.Get();
  *output = mojo::ArrayDataView<::ax::mojom::AXEventDataView>(pointer, message_);
}



}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_SHARED_H_