// ui/accessibility/mojom/ax_tree_update.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_tree_update.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom.h"
#include "ui/accessibility/mojom/ax_node_data.mojom.h"
#include "ui/accessibility/mojom/ax_tree_data.mojom.h"
#include "ui/accessibility/mojom/ax_tree_checks.mojom.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_tree_update_mojom_traits.h"


namespace ui { struct AXTreeData; }


namespace ax::mojom {








class  AXTreeUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXTreeUpdate, T>::value>;
  using DataView = AXTreeUpdateDataView;
  using Data_ = internal::AXTreeUpdate_Data;

  template <typename... Args>
  static AXTreeUpdatePtr New(Args&&... args) {
    return AXTreeUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXTreeUpdatePtr From(const U& u) {
    return mojo::TypeConverter<AXTreeUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXTreeUpdate>::Convert(*this);
  }


  AXTreeUpdate();

  AXTreeUpdate(
      bool has_tree_data,
      ::ui::AXTreeData tree_data,
      int32_t node_id_to_clear,
      int32_t root_id,
      std::vector<::ui::AXNodeData> nodes,
      ::ax::mojom::EventFrom event_from,
      ::ax::mojom::Action event_from_action,
      std::vector<::ui::AXEventIntent> event_intents,
      const std::optional<::ui::AXTreeChecks>& tree_checks);

AXTreeUpdate(const AXTreeUpdate&) = delete;
AXTreeUpdate& operator=(const AXTreeUpdate&) = delete;

  ~AXTreeUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXTreeUpdatePtr>
  AXTreeUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXTreeUpdate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXTreeUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXTreeUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXTreeUpdate_UnserializedMessageContext<
            UserType, AXTreeUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXTreeUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXTreeUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXTreeUpdate_UnserializedMessageContext<
            UserType, AXTreeUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXTreeUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_tree_data;
  
  ::ui::AXTreeData tree_data;
  
  int32_t node_id_to_clear;
  
  int32_t root_id;
  
  std::vector<::ui::AXNodeData> nodes;
  
  ::ax::mojom::EventFrom event_from;
  
  ::ax::mojom::Action event_from_action;
  
  std::vector<::ui::AXEventIntent> event_intents;
  
  std::optional<::ui::AXTreeChecks> tree_checks;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXTreeUpdatePtr AXTreeUpdate::Clone() const {
  return New(
      mojo::Clone(has_tree_data),
      mojo::Clone(tree_data),
      mojo::Clone(node_id_to_clear),
      mojo::Clone(root_id),
      mojo::Clone(nodes),
      mojo::Clone(event_from),
      mojo::Clone(event_from_action),
      mojo::Clone(event_intents),
      mojo::Clone(tree_checks)
  );
}

template <typename T, AXTreeUpdate::EnableIfSame<T>*>
bool AXTreeUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_tree_data, other_struct.has_tree_data))
    return false;
  if (!mojo::Equals(this->tree_data, other_struct.tree_data))
    return false;
  if (!mojo::Equals(this->node_id_to_clear, other_struct.node_id_to_clear))
    return false;
  if (!mojo::Equals(this->root_id, other_struct.root_id))
    return false;
  if (!mojo::Equals(this->nodes, other_struct.nodes))
    return false;
  if (!mojo::Equals(this->event_from, other_struct.event_from))
    return false;
  if (!mojo::Equals(this->event_from_action, other_struct.event_from_action))
    return false;
  if (!mojo::Equals(this->event_intents, other_struct.event_intents))
    return false;
  if (!mojo::Equals(this->tree_checks, other_struct.tree_checks))
    return false;
  return true;
}

template <typename T, AXTreeUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_tree_data < rhs.has_tree_data)
    return true;
  if (rhs.has_tree_data < lhs.has_tree_data)
    return false;
  if (lhs.tree_data < rhs.tree_data)
    return true;
  if (rhs.tree_data < lhs.tree_data)
    return false;
  if (lhs.node_id_to_clear < rhs.node_id_to_clear)
    return true;
  if (rhs.node_id_to_clear < lhs.node_id_to_clear)
    return false;
  if (lhs.root_id < rhs.root_id)
    return true;
  if (rhs.root_id < lhs.root_id)
    return false;
  if (lhs.nodes < rhs.nodes)
    return true;
  if (rhs.nodes < lhs.nodes)
    return false;
  if (lhs.event_from < rhs.event_from)
    return true;
  if (rhs.event_from < lhs.event_from)
    return false;
  if (lhs.event_from_action < rhs.event_from_action)
    return true;
  if (rhs.event_from_action < lhs.event_from_action)
    return false;
  if (lhs.event_intents < rhs.event_intents)
    return true;
  if (rhs.event_intents < lhs.event_intents)
    return false;
  if (lhs.tree_checks < rhs.tree_checks)
    return true;
  if (rhs.tree_checks < lhs.tree_checks)
    return false;
  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::AXTreeUpdate::DataView,
                                         ::ax::mojom::AXTreeUpdatePtr> {
  static bool IsNull(const ::ax::mojom::AXTreeUpdatePtr& input) { return !input; }
  static void SetToNull(::ax::mojom::AXTreeUpdatePtr* output) { output->reset(); }

  static decltype(::ax::mojom::AXTreeUpdate::has_tree_data) has_tree_data(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->has_tree_data;
  }

  static const decltype(::ax::mojom::AXTreeUpdate::tree_data)& tree_data(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->tree_data;
  }

  static decltype(::ax::mojom::AXTreeUpdate::node_id_to_clear) node_id_to_clear(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->node_id_to_clear;
  }

  static decltype(::ax::mojom::AXTreeUpdate::root_id) root_id(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->root_id;
  }

  static const decltype(::ax::mojom::AXTreeUpdate::nodes)& nodes(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->nodes;
  }

  static decltype(::ax::mojom::AXTreeUpdate::event_from) event_from(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->event_from;
  }

  static decltype(::ax::mojom::AXTreeUpdate::event_from_action) event_from_action(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->event_from_action;
  }

  static const decltype(::ax::mojom::AXTreeUpdate::event_intents)& event_intents(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->event_intents;
  }

  static const decltype(::ax::mojom::AXTreeUpdate::tree_checks)& tree_checks(
      const ::ax::mojom::AXTreeUpdatePtr& input) {
    return input->tree_checks;
  }

  static bool Read(::ax::mojom::AXTreeUpdate::DataView input, ::ax::mojom::AXTreeUpdatePtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_UPDATE_MOJOM_H_