// ui/accessibility/mojom/ax_tree_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_tree_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"




#include "ui/accessibility/mojom/ax_tree_data.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXTreeDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXTreeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tree_id(input)) in_tree_id = Traits::tree_id(input);
    mojo::internal::MessageFragment<decltype(fragment->tree_id)>
        tree_id_fragment(fragment.message());
    tree_id_fragment.Claim(&fragment->tree_id);
    
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
      in_tree_id,
      tree_id_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tree_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tree_id in AXTreeData struct");

    decltype(Traits::parent_tree_id(input)) in_parent_tree_id = Traits::parent_tree_id(input);
    mojo::internal::MessageFragment<decltype(fragment->parent_tree_id)>
        parent_tree_id_fragment(fragment.message());
    parent_tree_id_fragment.Claim(&fragment->parent_tree_id);
    
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
      in_parent_tree_id,
      parent_tree_id_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parent_tree_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent_tree_id in AXTreeData struct");

    decltype(Traits::focused_tree_id(input)) in_focused_tree_id = Traits::focused_tree_id(input);
    mojo::internal::MessageFragment<decltype(fragment->focused_tree_id)>
        focused_tree_id_fragment(fragment.message());
    focused_tree_id_fragment.Claim(&fragment->focused_tree_id);
    
    mojo::internal::Serialize<::ax::mojom::AXTreeIDDataView>(
      in_focused_tree_id,
      focused_tree_id_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->focused_tree_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null focused_tree_id in AXTreeData struct");

    decltype(Traits::doctype(input)) in_doctype = Traits::doctype(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->doctype)::BaseType> doctype_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_doctype,
      doctype_fragment);

    fragment->doctype.Set(
        doctype_fragment.is_null() ? nullptr : doctype_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->doctype.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null doctype in AXTreeData struct");

    fragment->loaded = Traits::loaded(input);

    fragment->loading_progress = Traits::loading_progress(input);

    decltype(Traits::mimetype(input)) in_mimetype = Traits::mimetype(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mimetype)::BaseType> mimetype_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mimetype,
      mimetype_fragment);

    fragment->mimetype.Set(
        mimetype_fragment.is_null() ? nullptr : mimetype_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mimetype.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mimetype in AXTreeData struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in AXTreeData struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in AXTreeData struct");

    fragment->focus_id = Traits::focus_id(input);

    fragment->sel_is_backward = Traits::sel_is_backward(input);

    fragment->sel_anchor_object_id = Traits::sel_anchor_object_id(input);

    fragment->sel_anchor_offset = Traits::sel_anchor_offset(input);

    
    mojo::internal::Serialize<::ax::mojom::TextAffinity>(
      Traits::sel_anchor_affinity(input),
      &fragment->sel_anchor_affinity);

    fragment->sel_focus_object_id = Traits::sel_focus_object_id(input);

    fragment->sel_focus_offset = Traits::sel_focus_offset(input);

    
    mojo::internal::Serialize<::ax::mojom::TextAffinity>(
      Traits::sel_focus_affinity(input),
      &fragment->sel_focus_affinity);

    fragment->root_scroller_id = Traits::root_scroller_id(input);

    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType>
        metadata_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& metadata_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_metadata,
      metadata_fragment,
      &metadata_validate_params);

    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  }

  static bool Deserialize(::ax::mojom::internal::AXTreeData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXTreeDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {

inline void AXTreeDataDataView::GetTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetParentTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->parent_tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetFocusedTreeIdDataView(
    ::ax::mojom::AXTreeIDDataView* output) {
  auto pointer = &data_->focused_tree_id;
  *output = ::ax::mojom::AXTreeIDDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetDoctypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->doctype.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetMimetypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mimetype.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AXTreeDataDataView::GetMetadataDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->metadata.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_DATA_MOJOM_SHARED_H_