// ui/accessibility/mojom/ax_relative_bounds.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"

#include "ui/accessibility/mojom/ax_relative_bounds.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXRelativeBoundsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXRelativeBoundsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXRelativeBounds_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->offset_container_id = Traits::offset_container_id(input);

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in AXRelativeBounds struct");

      decltype(Traits::transform(input)) in_transform = Traits::transform(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transform)::BaseType> transform_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_transform,
        transform_fragment);

      fragment->transform.Set(
          transform_fragment.is_null() ? nullptr : transform_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->transform.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform in AXRelativeBounds struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_SEND_VALIDATION_H_