// ui/accessibility/mojom/ax_node_data.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"


namespace ax::mojom {
class AXBitsetDataDataView;

class AXNodeDataDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXBitsetDataDataView> {
  using Data = ::ax::mojom::internal::AXBitsetData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ax::mojom::AXNodeDataDataView> {
  using Data = ::ax::mojom::internal::AXNodeData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXBitsetDataDataView {
 public:
  AXBitsetDataDataView() = default;

  AXBitsetDataDataView(
      internal::AXBitsetData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t set_bits() const {
    return data_->set_bits;
  }
  uint32_t values() const {
    return data_->values;
  }
 private:
  internal::AXBitsetData_Data* data_ = nullptr;
};


class AXNodeDataDataView {
 public:
  AXNodeDataDataView() = default;

  AXNodeDataDataView(
      internal::AXNodeData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRole(UserType* output) const {
    auto data_value = data_->role;
    return mojo::internal::Deserialize<::ax::mojom::Role>(
        data_value, output);
  }
  ::ax::mojom::Role role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ax::mojom::Role>(data_->role));
  }
  uint32_t state() const {
    return data_->state;
  }
  uint64_t actions() const {
    return data_->actions;
  }
  inline void GetStringAttributesDataView(
      mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringAttributes(UserType* output) {
    
    auto* pointer = data_->string_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetIntAttributesDataView(
      mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntAttributes(UserType* output) {
    
    auto* pointer = data_->int_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>>(
        pointer, output, message_);
  }
  inline void GetFloatAttributesDataView(
      mojo::MapDataView<::ax::mojom::FloatAttribute, float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFloatAttributes(UserType* output) {
    
    auto* pointer = data_->float_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::FloatAttribute, float>>(
        pointer, output, message_);
  }
  inline void GetBoolAttributesDataView(
      mojo::MapDataView<::ax::mojom::BoolAttribute, bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoolAttributes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<::ax::mojom::BoolAttribute, bool>, UserType>(),
    "Attempting to read the optional `bool_attributes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBoolAttributes` instead "
    "of `ReadBoolAttributes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bool_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::BoolAttribute, bool>>(
        pointer, output, message_);
  }
  inline void GetIntlistAttributesDataView(
      mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntlistAttributes(UserType* output) {
    
    auto* pointer = data_->intlist_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>>(
        pointer, output, message_);
  }
  inline void GetStringlistAttributesDataView(
      mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringlistAttributes(UserType* output) {
    
    auto* pointer = data_->stringlist_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
  inline void GetHtmlAttributesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtmlAttributes(UserType* output) {
    
    auto* pointer = data_->html_attributes.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetChildIdsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildIds(UserType* output) {
    
    auto* pointer = data_->child_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetRelativeBoundsDataView(
      ::ax::mojom::AXRelativeBoundsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeBounds(UserType* output) {
    
    auto* pointer = data_->relative_bounds.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXRelativeBoundsDataView>(
        pointer, output, message_);
  }
  inline void GetBoolAttributesDataDataView(
      AXBitsetDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoolAttributesData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::ax::mojom::AXBitsetDataDataView, UserType>(),
    "Attempting to read the optional `bool_attributes_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBoolAttributesData` instead "
    "of `ReadBoolAttributesData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bool_attributes_data.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXBitsetDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::AXNodeData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_DATA_VIEW_H_