// ui/accessibility/mojom/ax_location_and_scroll_updates.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-import-headers.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-test-utils.h"


namespace ax::mojom {
AXLocationChange::AXLocationChange()
    : id(),
      new_location() {}

AXLocationChange::AXLocationChange(
    int32_t id_in,
    const ::ui::AXRelativeBounds& new_location_in)
    : id(std::move(id_in)),
      new_location(std::move(new_location_in)) {}

AXLocationChange::~AXLocationChange() = default;

void AXLocationChange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_location"), this->new_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::AXRelativeBounds&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXLocationChange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AXScrollChange::AXScrollChange()
    : id(),
      scroll_x(),
      scroll_y() {}

AXScrollChange::AXScrollChange(
    int32_t id_in,
    int32_t scroll_x_in,
    int32_t scroll_y_in)
    : id(std::move(id_in)),
      scroll_x(std::move(scroll_x_in)),
      scroll_y(std::move(scroll_y_in)) {}

AXScrollChange::~AXScrollChange() = default;

void AXScrollChange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_x"), this->scroll_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_y"), this->scroll_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXScrollChange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AXLocationAndScrollUpdates::AXLocationAndScrollUpdates()
    : location_changes(),
      scroll_changes() {}

AXLocationAndScrollUpdates::AXLocationAndScrollUpdates(
    std::vector<::ui::AXLocationChange> location_changes_in,
    std::vector<::ui::AXScrollChange> scroll_changes_in)
    : location_changes(std::move(location_changes_in)),
      scroll_changes(std::move(scroll_changes_in)) {}

AXLocationAndScrollUpdates::~AXLocationAndScrollUpdates() = default;

void AXLocationAndScrollUpdates::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_changes"), this->location_changes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXLocationChange>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_changes"), this->scroll_changes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXScrollChange>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXLocationAndScrollUpdates::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom


namespace mojo {


// static
bool StructTraits<::ax::mojom::AXLocationChange::DataView, ::ax::mojom::AXLocationChangePtr>::Read(
    ::ax::mojom::AXLocationChange::DataView input,
    ::ax::mojom::AXLocationChangePtr* output) {
  bool success = true;
  ::ax::mojom::AXLocationChangePtr result(::ax::mojom::AXLocationChange::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadNewLocation(&result->new_location))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::AXScrollChange::DataView, ::ax::mojom::AXScrollChangePtr>::Read(
    ::ax::mojom::AXScrollChange::DataView input,
    ::ax::mojom::AXScrollChangePtr* output) {
  bool success = true;
  ::ax::mojom::AXScrollChangePtr result(::ax::mojom::AXScrollChange::New());
  
      if (success)
        result->id = input.id();
      if (success)
        result->scroll_x = input.scroll_x();
      if (success)
        result->scroll_y = input.scroll_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ax::mojom::AXLocationAndScrollUpdates::DataView, ::ax::mojom::AXLocationAndScrollUpdatesPtr>::Read(
    ::ax::mojom::AXLocationAndScrollUpdates::DataView input,
    ::ax::mojom::AXLocationAndScrollUpdatesPtr* output) {
  bool success = true;
  ::ax::mojom::AXLocationAndScrollUpdatesPtr result(::ax::mojom::AXLocationAndScrollUpdates::New());
  
      if (success && !input.ReadLocationChanges(&result->location_changes))
        success = false;
      if (success && !input.ReadScrollChanges(&result->scroll_changes))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom {




}  // ax::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif