// ui/accessibility/mojom/ax_event_intent.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_event_intent.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_event_intent.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_event_intent.mojom-import-headers.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-test-utils.h"


namespace ax::mojom {
EventIntent::EventIntent()
    : command(),
      input_event_type(),
      text_boundary(),
      move_direction() {}

EventIntent::EventIntent(
    ::ax::mojom::Command command_in,
    ::ax::mojom::InputEventType input_event_type_in,
    ::ax::mojom::TextBoundary text_boundary_in,
    ::ax::mojom::MoveDirection move_direction_in)
    : command(std::move(command_in)),
      input_event_type(std::move(input_event_type_in)),
      text_boundary(std::move(text_boundary_in)),
      move_direction(std::move(move_direction_in)) {}

EventIntent::~EventIntent() = default;

void EventIntent::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "command"), this->command,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::Command>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_event_type"), this->input_event_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::InputEventType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_boundary"), this->text_boundary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::TextBoundary>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "move_direction"), this->move_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::MoveDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EventIntent::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom


namespace mojo {


// static
bool StructTraits<::ax::mojom::EventIntent::DataView, ::ax::mojom::EventIntentPtr>::Read(
    ::ax::mojom::EventIntent::DataView input,
    ::ax::mojom::EventIntentPtr* output) {
  bool success = true;
  ::ax::mojom::EventIntentPtr result(::ax::mojom::EventIntent::New());
  
      if (success && !input.ReadCommand(&result->command))
        success = false;
      if (success && !input.ReadInputEventType(&result->input_event_type))
        success = false;
      if (success && !input.ReadTextBoundary(&result->text_boundary))
        success = false;
      if (success && !input.ReadMoveDirection(&result->move_direction))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom {




}  // ax::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif