// GENERATED FILE
// This file generated by DomDistillerJs protoc plugin.
#include "dom_distiller.pb.h"

// base dependencies
#include "base/values.h"

#include <memory>
#include <string>
#include <utility>

namespace dom_distiller {
  namespace proto {
    namespace json {
      class DistilledContent {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::DistilledContent* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_html(value->GetString());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::DistilledContent& message) {
          base::Value::Dict dict;
          if (message.has_html()) {
            dict.Set("1", message.html());
          }
          return base::Value(std::move(dict));
        }
      };

      class PaginationInfo {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::PaginationInfo* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_next_page(value->GetString());
          }
          if (const auto* value = dict->Find("2")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_prev_page(value->GetString());
          }
          if (const auto* value = dict->Find("3")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_canonical_page(value->GetString());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::PaginationInfo& message) {
          base::Value::Dict dict;
          if (message.has_next_page()) {
            dict.Set("1", message.next_page());
          }
          if (message.has_prev_page()) {
            dict.Set("2", message.prev_page());
          }
          if (message.has_canonical_page()) {
            dict.Set("3", message.canonical_page());
          }
          return base::Value(std::move(dict));
        }
      };

      class MarkupArticle {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::MarkupArticle* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_published_time(value->GetString());
          }
          if (const auto* value = dict->Find("2")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_modified_time(value->GetString());
          }
          if (const auto* value = dict->Find("3")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_expiration_time(value->GetString());
          }
          if (const auto* value = dict->Find("4")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_section(value->GetString());
          }
          if (const auto* value = dict->Find("5")) {
            if (!value->is_list()) {
              goto error;
            }
            for (const auto& element : value->GetList()) {
              if (!element.is_string()) {
                goto error;
              }
              message->add_authors(element.GetString());
            }
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::MarkupArticle& message) {
          base::Value::Dict dict;
          if (message.has_published_time()) {
            dict.Set("1", message.published_time());
          }
          if (message.has_modified_time()) {
            dict.Set("2", message.modified_time());
          }
          if (message.has_expiration_time()) {
            dict.Set("3", message.expiration_time());
          }
          if (message.has_section()) {
            dict.Set("4", message.section());
          }
          {
            const auto& repeated_field = message.authors();
            base::Value::List field_list;
            field_list.reserve(repeated_field.size());
            for (const auto& element : repeated_field) {
              field_list.Append(element);
            }
            dict.Set("5", std::move(field_list));
          }
          return base::Value(std::move(dict));
        }
      };

      class MarkupImage {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::MarkupImage* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_url(value->GetString());
          }
          if (const auto* value = dict->Find("2")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_secure_url(value->GetString());
          }
          if (const auto* value = dict->Find("3")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_type(value->GetString());
          }
          if (const auto* value = dict->Find("4")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_caption(value->GetString());
          }
          if (const auto* value = dict->Find("5")) {
            if (!(*value).is_int()) {
              goto error;
            }
            message->set_width(value->GetInt());
          }
          if (const auto* value = dict->Find("6")) {
            if (!(*value).is_int()) {
              goto error;
            }
            message->set_height(value->GetInt());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::MarkupImage& message) {
          base::Value::Dict dict;
          if (message.has_url()) {
            dict.Set("1", message.url());
          }
          if (message.has_secure_url()) {
            dict.Set("2", message.secure_url());
          }
          if (message.has_type()) {
            dict.Set("3", message.type());
          }
          if (message.has_caption()) {
            dict.Set("4", message.caption());
          }
          if (message.has_width()) {
            dict.Set("5", message.width());
          }
          if (message.has_height()) {
            dict.Set("6", message.height());
          }
          return base::Value(std::move(dict));
        }
      };

      class MarkupInfo {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::MarkupInfo* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_title(value->GetString());
          }
          if (const auto* value = dict->Find("2")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_type(value->GetString());
          }
          if (const auto* value = dict->Find("3")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_url(value->GetString());
          }
          if (const auto* value = dict->Find("4")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_description(value->GetString());
          }
          if (const auto* value = dict->Find("5")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_publisher(value->GetString());
          }
          if (const auto* value = dict->Find("6")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_copyright(value->GetString());
          }
          if (const auto* value = dict->Find("7")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_author(value->GetString());
          }
          if (const auto* value = dict->Find("8")) {
            if (!dom_distiller::proto::json::MarkupArticle::ReadFromValue(*value, message->mutable_article())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("9")) {
            if (!value->is_list()) {
              goto error;
            }
            for (const auto& element : value->GetList()) {
              if (!dom_distiller::proto::json::MarkupImage::ReadFromValue(element, message->add_images())) {
                goto error;
              }
            }
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::MarkupInfo& message) {
          base::Value::Dict dict;
          if (message.has_title()) {
            dict.Set("1", message.title());
          }
          if (message.has_type()) {
            dict.Set("2", message.type());
          }
          if (message.has_url()) {
            dict.Set("3", message.url());
          }
          if (message.has_description()) {
            dict.Set("4", message.description());
          }
          if (message.has_publisher()) {
            dict.Set("5", message.publisher());
          }
          if (message.has_copyright()) {
            dict.Set("6", message.copyright());
          }
          if (message.has_author()) {
            dict.Set("7", message.author());
          }
          if (message.has_article()) {
            dict.Set("8",
                     dom_distiller::proto::json::MarkupArticle::WriteToValue(
                         message.article()));
          }
          {
            const auto& repeated_field = message.images();
            base::Value::List field_list;
            field_list.reserve(repeated_field.size());
            for (const auto& element : repeated_field) {
              field_list.Append(
                  dom_distiller::proto::json::MarkupImage::WriteToValue(element));
            }
            dict.Set("9", std::move(field_list));
          }
          return base::Value(std::move(dict));
        }
      };

      class TimingEntry {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::TimingEntry* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_name(value->GetString());
          }
          if (const auto* value = dict->Find("2")) {
            if (!((*value).is_int() || (*value).is_double())) {
              goto error;
            }
            message->set_time(value->GetDouble());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::TimingEntry& message) {
          base::Value::Dict dict;
          if (message.has_name()) {
            dict.Set("1", message.name());
          }
          if (message.has_time()) {
            dict.Set("2", message.time());
          }
          return base::Value(std::move(dict));
        }
      };

      class TimingInfo {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::TimingInfo* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!((*value).is_int() || (*value).is_double())) {
              goto error;
            }
            message->set_markup_parsing_time(value->GetDouble());
          }
          if (const auto* value = dict->Find("2")) {
            if (!((*value).is_int() || (*value).is_double())) {
              goto error;
            }
            message->set_document_construction_time(value->GetDouble());
          }
          if (const auto* value = dict->Find("3")) {
            if (!((*value).is_int() || (*value).is_double())) {
              goto error;
            }
            message->set_article_processing_time(value->GetDouble());
          }
          if (const auto* value = dict->Find("4")) {
            if (!((*value).is_int() || (*value).is_double())) {
              goto error;
            }
            message->set_formatting_time(value->GetDouble());
          }
          if (const auto* value = dict->Find("5")) {
            if (!((*value).is_int() || (*value).is_double())) {
              goto error;
            }
            message->set_total_time(value->GetDouble());
          }
          if (const auto* value = dict->Find("6")) {
            if (!value->is_list()) {
              goto error;
            }
            for (const auto& element : value->GetList()) {
              if (!dom_distiller::proto::json::TimingEntry::ReadFromValue(element, message->add_other_times())) {
                goto error;
              }
            }
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::TimingInfo& message) {
          base::Value::Dict dict;
          if (message.has_markup_parsing_time()) {
            dict.Set("1", message.markup_parsing_time());
          }
          if (message.has_document_construction_time()) {
            dict.Set("2", message.document_construction_time());
          }
          if (message.has_article_processing_time()) {
            dict.Set("3", message.article_processing_time());
          }
          if (message.has_formatting_time()) {
            dict.Set("4", message.formatting_time());
          }
          if (message.has_total_time()) {
            dict.Set("5", message.total_time());
          }
          {
            const auto& repeated_field = message.other_times();
            base::Value::List field_list;
            field_list.reserve(repeated_field.size());
            for (const auto& element : repeated_field) {
              field_list.Append(
                  dom_distiller::proto::json::TimingEntry::WriteToValue(element));
            }
            dict.Set("6", std::move(field_list));
          }
          return base::Value(std::move(dict));
        }
      };

      class DebugInfo {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::DebugInfo* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_log(value->GetString());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::DebugInfo& message) {
          base::Value::Dict dict;
          if (message.has_log()) {
            dict.Set("1", message.log());
          }
          return base::Value(std::move(dict));
        }
      };

      class StatisticsInfo {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::StatisticsInfo* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_int()) {
              goto error;
            }
            message->set_word_count(value->GetInt());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::StatisticsInfo& message) {
          base::Value::Dict dict;
          if (message.has_word_count()) {
            dict.Set("1", message.word_count());
          }
          return base::Value(std::move(dict));
        }
      };

      class DomDistillerResult {
       public:
        class ContentImage {
         public:
          static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::DomDistillerResult::ContentImage* message) {
            const base::Value::Dict* dict = dict_value.GetIfDict();
            if (!dict) goto error;
            if (const auto* value = dict->Find("1")) {
              if (!(*value).is_string()) {
                goto error;
              }
              message->set_url(value->GetString());
            }
            return true;

          error:
            return false;
          }

          static base::Value WriteToValue(const dom_distiller::proto::DomDistillerResult::ContentImage& message) {
            base::Value::Dict dict;
            if (message.has_url()) {
              dict.Set("1", message.url());
            }
            return base::Value(std::move(dict));
          }
        };

        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::DomDistillerResult* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_title(value->GetString());
          }
          if (const auto* value = dict->Find("2")) {
            if (!dom_distiller::proto::json::DistilledContent::ReadFromValue(*value, message->mutable_distilled_content())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("3")) {
            if (!dom_distiller::proto::json::PaginationInfo::ReadFromValue(*value, message->mutable_pagination_info())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("5")) {
            if (!dom_distiller::proto::json::MarkupInfo::ReadFromValue(*value, message->mutable_markup_info())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("6")) {
            if (!dom_distiller::proto::json::TimingInfo::ReadFromValue(*value, message->mutable_timing_info())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("7")) {
            if (!dom_distiller::proto::json::DebugInfo::ReadFromValue(*value, message->mutable_debug_info())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("8")) {
            if (!dom_distiller::proto::json::StatisticsInfo::ReadFromValue(*value, message->mutable_statistics_info())) {
              goto error;
            }
          }
          if (const auto* value = dict->Find("9")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_text_direction(value->GetString());
          }
          if (const auto* value = dict->Find("10")) {
            if (!value->is_list()) {
              goto error;
            }
            for (const auto& element : value->GetList()) {
              if (!dom_distiller::proto::json::DomDistillerResult::ContentImage::ReadFromValue(element, message->add_content_images())) {
                goto error;
              }
            }
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::DomDistillerResult& message) {
          base::Value::Dict dict;
          if (message.has_title()) {
            dict.Set("1", message.title());
          }
          if (message.has_distilled_content()) {
            dict.Set("2",
                     dom_distiller::proto::json::DistilledContent::WriteToValue(
                         message.distilled_content()));
          }
          if (message.has_pagination_info()) {
            dict.Set("3",
                     dom_distiller::proto::json::PaginationInfo::WriteToValue(
                         message.pagination_info()));
          }
          if (message.has_markup_info()) {
            dict.Set("5",
                     dom_distiller::proto::json::MarkupInfo::WriteToValue(
                         message.markup_info()));
          }
          if (message.has_timing_info()) {
            dict.Set("6",
                     dom_distiller::proto::json::TimingInfo::WriteToValue(
                         message.timing_info()));
          }
          if (message.has_debug_info()) {
            dict.Set("7",
                     dom_distiller::proto::json::DebugInfo::WriteToValue(
                         message.debug_info()));
          }
          if (message.has_statistics_info()) {
            dict.Set("8",
                     dom_distiller::proto::json::StatisticsInfo::WriteToValue(
                         message.statistics_info()));
          }
          if (message.has_text_direction()) {
            dict.Set("9", message.text_direction());
          }
          {
            const auto& repeated_field = message.content_images();
            base::Value::List field_list;
            field_list.reserve(repeated_field.size());
            for (const auto& element : repeated_field) {
              field_list.Append(
                  dom_distiller::proto::json::DomDistillerResult::ContentImage::WriteToValue(element));
            }
            dict.Set("10", std::move(field_list));
          }
          return base::Value(std::move(dict));
        }
      };

      class DomDistillerOptions {
       public:
        static bool ReadFromValue(const base::Value& dict_value, dom_distiller::proto::DomDistillerOptions* message) {
          const base::Value::Dict* dict = dict_value.GetIfDict();
          if (!dict) goto error;
          if (const auto* value = dict->Find("1")) {
            if (!(*value).is_bool()) {
              goto error;
            }
            message->set_extract_text_only(value->GetBool());
          }
          if (const auto* value = dict->Find("2")) {
            if (!(*value).is_int()) {
              goto error;
            }
            message->set_debug_level(value->GetInt());
          }
          if (const auto* value = dict->Find("3")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_original_url(value->GetString());
          }
          if (const auto* value = dict->Find("4")) {
            if (!(*value).is_string()) {
              goto error;
            }
            message->set_pagination_algo(value->GetString());
          }
          return true;

        error:
          return false;
        }

        static base::Value WriteToValue(const dom_distiller::proto::DomDistillerOptions& message) {
          base::Value::Dict dict;
          if (message.has_extract_text_only()) {
            dict.Set("1", message.extract_text_only());
          }
          if (message.has_debug_level()) {
            dict.Set("2", message.debug_level());
          }
          if (message.has_original_url()) {
            dict.Set("3", message.original_url());
          }
          if (message.has_pagination_algo()) {
            dict.Set("4", message.pagination_algo());
          }
          return base::Value(std::move(dict));
        }
      };

    }
  }
}
