import '../../ui/legacy/legacy.js';
import * as Common from '../../core/common/common.js';
import * as Platform from '../../core/platform/platform.js';
import * as SDK from '../../core/sdk/sdk.js';
import * as UI from '../../ui/legacy/legacy.js';
import { ConsoleFilter, type LevelsMask } from './ConsoleFilter.js';
import { ConsolePinPane } from './ConsolePinPane.js';
import { ConsoleViewMessage } from './ConsoleViewMessage.js';
import { type ConsoleViewportElement, type ConsoleViewportProvider } from './ConsoleViewport.js';
export declare class ConsoleView extends UI.Widget.VBox implements UI.SearchableView.Searchable, ConsoleViewportProvider, SDK.TargetManager.SDKModelObserver<SDK.ConsoleModel.ConsoleModel> {
    #private;
    private readonly sidebar;
    private isSidebarOpen;
    private filter;
    private readonly consoleToolbarContainer;
    private readonly splitWidget;
    private readonly contentsElement;
    private visibleViewMessages;
    private hiddenByFilterCount;
    private shouldBeHiddenCache;
    private lastShownHiddenByFilterCount;
    private currentMatchRangeIndex;
    private searchRegex;
    private groupableMessages;
    private readonly groupableMessageTitle;
    private readonly shortcuts;
    private regexMatchRanges;
    private readonly consoleContextSelector;
    private readonly filterStatusText;
    private readonly showSettingsPaneSetting;
    private readonly showSettingsPaneButton;
    private readonly progressToolbarItem;
    private readonly groupSimilarSetting;
    private readonly showCorsErrorsSetting;
    private readonly timestampsSetting;
    private readonly consoleHistoryAutocompleteSetting;
    private selfXssWarningDisabledSetting;
    readonly pinPane: ConsolePinPane;
    private viewport;
    private messagesElement;
    private messagesCountElement;
    private viewportThrottler;
    private pendingBatchResize;
    private readonly onMessageResizedBound;
    private readonly promptElement;
    private readonly linkifier;
    private consoleMessages;
    private consoleGroupStarts;
    private prompt;
    private immediatelyFilterMessagesForTest?;
    private maybeDirtyWhileMuted?;
    private scheduledRefreshPromiseForTest?;
    private needsFullUpdate?;
    private buildHiddenCacheTimeout?;
    private searchShouldJumpBackwards?;
    private searchProgressIndicator?;
    private muteViewportUpdates?;
    private waitForScrollTimeout?;
    private issueCounter;
    private pendingSidebarMessages;
    private userHasOpenedSidebarAtLeastOnce;
    private issueToolbarThrottle;
    private requestResolver;
    private issueResolver;
    private aiCodeCompletionSetting;
    private aiCodeCompletionSummaryToolbarContainer?;
    private aiCodeCompletionSummaryToolbar?;
    constructor(viewportThrottlerTimeout: number);
    static instance(opts?: {
        forceNew: boolean;
        viewportThrottlerTimeout?: number;
    }): ConsoleView;
    createAiCodeCompletionSummaryToolbar(): void;
    clearConsole(): void;
    issuesCountUpdatedForTest(): void;
    modelAdded(model: SDK.ConsoleModel.ConsoleModel): void;
    modelRemoved(model: SDK.ConsoleModel.ConsoleModel): void;
    private onFilterChanged;
    protected setImmediatelyFilterMessagesForTest(): void;
    searchableView(): UI.SearchableView.SearchableView;
    clearHistory(): void;
    private consoleHistoryAutocompleteChanged;
    itemCount(): number;
    itemElement(index: number): ConsoleViewportElement | null;
    fastHeight(index: number): number;
    minimumRowHeight(): number;
    private registerWithMessageSink;
    private addSinkMessage;
    private consoleTimestampsSettingChanged;
    private executionContextChanged;
    willHide(): void;
    wasShown(): void;
    focus(): void;
    focusPrompt(): void;
    restoreScrollPositions(): void;
    onResize(): void;
    private hidePromptSuggestBox;
    private invalidateViewport;
    onDetach(): void;
    private updateIssuesToolbarItem;
    private scheduleViewportRefresh;
    getScheduledRefreshPromiseForTest(): Promise<void> | undefined;
    private immediatelyScrollToBottom;
    private updateFilterStatus;
    private onConsoleMessageAdded;
    private addConsoleMessage;
    private onConsoleMessageUpdated;
    private consoleMessageAddedForTest;
    private shouldMessageBeVisible;
    private computeShouldMessageBeVisible;
    private appendMessageToEnd;
    private messageAppendedForTests;
    private createViewMessage;
    private onMessageResized;
    private consoleCleared;
    private handleContextMenuEvent;
    private saveConsole;
    private copyConsole;
    private tryToCollapseMessages;
    private buildHiddenCache;
    private cancelBuildHiddenCache;
    private updateMessageList;
    private addGroupableMessagesToEnd;
    private messagesClicked;
    private messagesKeyDown;
    private messagesPasted;
    private registerShortcuts;
    private clearPromptBackwards;
    private promptKeyDown;
    private keyDown;
    private printResult;
    private commandEvaluated;
    elementsToRestoreScrollPositionsFor(): Element[];
    onSearchCanceled(): void;
    performSearch(searchConfig: UI.SearchableView.SearchConfig, shouldJump: boolean, jumpBackwards?: boolean): void;
    private cleanupAfterSearch;
    private searchFinishedForTests;
    private searchMessage;
    jumpToNextSearchResult(): void;
    jumpToPreviousSearchResult(): void;
    supportsCaseSensitiveSearch(): boolean;
    supportsWholeWordSearch(): boolean;
    supportsRegexSearch(): boolean;
    private jumpToMatch;
    private updateStickToBottomOnPointerDown;
    private updateStickToBottomOnPointerUp;
    private updateViewportStickinessForTest;
    private updateStickToBottomOnWheel;
    private promptTextChanged;
    private promptTextChangedForTest;
    private isScrolledToBottom;
    private onAiCodeCompletionSettingChanged;
    private isAiCodeCompletionEnabled;
}
export declare class ConsoleViewFilter {
    private readonly filterChanged;
    messageLevelFiltersSetting: Common.Settings.Setting<LevelsMask>;
    hideNetworkMessagesSetting: Common.Settings.Setting<boolean>;
    filterByExecutionContextSetting: Common.Settings.Setting<boolean>;
    private readonly suggestionBuilder;
    readonly textFilterUI: UI.Toolbar.ToolbarInput;
    private readonly textFilterSetting;
    private readonly filterParser;
    currentFilter: ConsoleFilter;
    private levelLabels;
    readonly levelMenuButton: UI.Toolbar.ToolbarMenuButton;
    readonly levelMenuButtonInfo: UI.Toolbar.ToolbarItem;
    constructor(filterChangedCallback: () => void);
    onMessageAdded(message: SDK.ConsoleModel.ConsoleMessage): void;
    setLevelMenuOverridden(overridden: boolean): void;
    static levelFilterSetting(): Common.Settings.Setting<LevelsMask>;
    private updateCurrentFilter;
    private onFilterChanged;
    private updateLevelMenuButtonText;
    private appendLevelMenuItems;
    addMessageURLFilter(url: Platform.DevToolsPath.UrlString): void;
    shouldBeVisible(viewMessage: ConsoleViewMessage): boolean;
    clear(): void;
    reset(): void;
}
export declare class ActionDelegate implements UI.ActionRegistration.ActionDelegate {
    handleAction(_context: UI.Context.Context, actionId: string): boolean;
}
export interface RegexMatchRange {
    messageIndex: number;
    matchIndex: number;
}
