// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/performance_timeline.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace PerformanceTimeline {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "PerformanceTimeline";
const char Metainfo::commandPrefix[] = "PerformanceTimeline.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(LargestContentfulPaint)
    CRDTP_DESERIALIZE_FIELD_OPT("elementId", m_elementId),
    CRDTP_DESERIALIZE_FIELD("loadTime", m_loadTime),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD("renderTime", m_renderTime),
    CRDTP_DESERIALIZE_FIELD("size", m_size),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LargestContentfulPaint)
    CRDTP_SERIALIZE_FIELD("renderTime", m_renderTime);
    CRDTP_SERIALIZE_FIELD("loadTime", m_loadTime);
    CRDTP_SERIALIZE_FIELD("size", m_size);
    CRDTP_SERIALIZE_FIELD("elementId", m_elementId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(LayoutShiftAttribution)
    CRDTP_DESERIALIZE_FIELD("currentRect", m_currentRect),
    CRDTP_DESERIALIZE_FIELD_OPT("nodeId", m_nodeId),
    CRDTP_DESERIALIZE_FIELD("previousRect", m_previousRect),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LayoutShiftAttribution)
    CRDTP_SERIALIZE_FIELD("previousRect", m_previousRect);
    CRDTP_SERIALIZE_FIELD("currentRect", m_currentRect);
    CRDTP_SERIALIZE_FIELD("nodeId", m_nodeId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(LayoutShift)
    CRDTP_DESERIALIZE_FIELD("hadRecentInput", m_hadRecentInput),
    CRDTP_DESERIALIZE_FIELD("lastInputTime", m_lastInputTime),
    CRDTP_DESERIALIZE_FIELD("sources", m_sources),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LayoutShift)
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("hadRecentInput", m_hadRecentInput);
    CRDTP_SERIALIZE_FIELD("lastInputTime", m_lastInputTime);
    CRDTP_SERIALIZE_FIELD("sources", m_sources);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(TimelineEvent)
    CRDTP_DESERIALIZE_FIELD_OPT("duration", m_duration),
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
    CRDTP_DESERIALIZE_FIELD_OPT("layoutShiftDetails", m_layoutShiftDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("lcpDetails", m_lcpDetails),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("time", m_time),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(TimelineEvent)
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("time", m_time);
    CRDTP_SERIALIZE_FIELD("duration", m_duration);
    CRDTP_SERIALIZE_FIELD("lcpDetails", m_lcpDetails);
    CRDTP_SERIALIZE_FIELD("layoutShiftDetails", m_layoutShiftDetails);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::timelineEventAdded(std::unique_ptr<protocol::PerformanceTimeline::TimelineEvent> event)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("event"), event);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("PerformanceTimeline.timelineEventAdded", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void enable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::unique_ptr<protocol::Array<String>> eventTypes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD("eventTypes", eventTypes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.eventTypes));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("PerformanceTimeline.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("PerformanceTimeline"), SortedRedirects(), std::move(dispatcher));
}

} // PerformanceTimeline
} // namespace blink
} // namespace protocol
