// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/layer_tree.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace LayerTree {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "LayerTree";
const char Metainfo::commandPrefix[] = "LayerTree.";
const char Metainfo::version[] = "1.3";




const char* ScrollRect::TypeEnum::RepaintsOnScroll = "RepaintsOnScroll";
const char* ScrollRect::TypeEnum::TouchEventHandler = "TouchEventHandler";
const char* ScrollRect::TypeEnum::WheelEventHandler = "WheelEventHandler";
CRDTP_BEGIN_DESERIALIZER(ScrollRect)
    CRDTP_DESERIALIZE_FIELD("rect", m_rect),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ScrollRect)
    CRDTP_SERIALIZE_FIELD("rect", m_rect);
    CRDTP_SERIALIZE_FIELD("type", m_type);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(StickyPositionConstraint)
    CRDTP_DESERIALIZE_FIELD("containingBlockRect", m_containingBlockRect),
    CRDTP_DESERIALIZE_FIELD_OPT("nearestLayerShiftingContainingBlock", m_nearestLayerShiftingContainingBlock),
    CRDTP_DESERIALIZE_FIELD_OPT("nearestLayerShiftingStickyBox", m_nearestLayerShiftingStickyBox),
    CRDTP_DESERIALIZE_FIELD("stickyBoxRect", m_stickyBoxRect),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(StickyPositionConstraint)
    CRDTP_SERIALIZE_FIELD("stickyBoxRect", m_stickyBoxRect);
    CRDTP_SERIALIZE_FIELD("containingBlockRect", m_containingBlockRect);
    CRDTP_SERIALIZE_FIELD("nearestLayerShiftingStickyBox", m_nearestLayerShiftingStickyBox);
    CRDTP_SERIALIZE_FIELD("nearestLayerShiftingContainingBlock", m_nearestLayerShiftingContainingBlock);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PictureTile)
    CRDTP_DESERIALIZE_FIELD("picture", m_picture),
    CRDTP_DESERIALIZE_FIELD("x", m_x),
    CRDTP_DESERIALIZE_FIELD("y", m_y),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PictureTile)
    CRDTP_SERIALIZE_FIELD("x", m_x);
    CRDTP_SERIALIZE_FIELD("y", m_y);
    CRDTP_SERIALIZE_FIELD("picture", m_picture);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Layer)
    CRDTP_DESERIALIZE_FIELD_OPT("anchorX", m_anchorX),
    CRDTP_DESERIALIZE_FIELD_OPT("anchorY", m_anchorY),
    CRDTP_DESERIALIZE_FIELD_OPT("anchorZ", m_anchorZ),
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD("drawsContent", m_drawsContent),
    CRDTP_DESERIALIZE_FIELD("height", m_height),
    CRDTP_DESERIALIZE_FIELD_OPT("invisible", m_invisible),
    CRDTP_DESERIALIZE_FIELD("layerId", m_layerId),
    CRDTP_DESERIALIZE_FIELD("offsetX", m_offsetX),
    CRDTP_DESERIALIZE_FIELD("offsetY", m_offsetY),
    CRDTP_DESERIALIZE_FIELD("paintCount", m_paintCount),
    CRDTP_DESERIALIZE_FIELD_OPT("parentLayerId", m_parentLayerId),
    CRDTP_DESERIALIZE_FIELD_OPT("scrollRects", m_scrollRects),
    CRDTP_DESERIALIZE_FIELD_OPT("stickyPositionConstraint", m_stickyPositionConstraint),
    CRDTP_DESERIALIZE_FIELD_OPT("transform", m_transform),
    CRDTP_DESERIALIZE_FIELD("width", m_width),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Layer)
    CRDTP_SERIALIZE_FIELD("layerId", m_layerId);
    CRDTP_SERIALIZE_FIELD("parentLayerId", m_parentLayerId);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
    CRDTP_SERIALIZE_FIELD("offsetX", m_offsetX);
    CRDTP_SERIALIZE_FIELD("offsetY", m_offsetY);
    CRDTP_SERIALIZE_FIELD("width", m_width);
    CRDTP_SERIALIZE_FIELD("height", m_height);
    CRDTP_SERIALIZE_FIELD("transform", m_transform);
    CRDTP_SERIALIZE_FIELD("anchorX", m_anchorX);
    CRDTP_SERIALIZE_FIELD("anchorY", m_anchorY);
    CRDTP_SERIALIZE_FIELD("anchorZ", m_anchorZ);
    CRDTP_SERIALIZE_FIELD("paintCount", m_paintCount);
    CRDTP_SERIALIZE_FIELD("drawsContent", m_drawsContent);
    CRDTP_SERIALIZE_FIELD("invisible", m_invisible);
    CRDTP_SERIALIZE_FIELD("scrollRects", m_scrollRects);
    CRDTP_SERIALIZE_FIELD("stickyPositionConstraint", m_stickyPositionConstraint);
CRDTP_END_SERIALIZER();



// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::layerPainted(const String& layerId, std::unique_ptr<protocol::DOM::Rect> clip)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("layerId"), layerId);
    serializer.AddField(crdtp::MakeSpan("clip"), clip);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("LayerTree.layerPainted", serializer.Finish()));
}

void Frontend::layerTreeDidChange(std::unique_ptr<protocol::Array<protocol::LayerTree::Layer>> layers)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("layers"), layers);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("LayerTree.layerTreeDidChange", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void compositingReasons(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void loadSnapshot(const crdtp::Dispatchable& dispatchable);
    void makeSnapshot(const crdtp::Dispatchable& dispatchable);
    void profileSnapshot(const crdtp::Dispatchable& dispatchable);
    void releaseSnapshot(const crdtp::Dispatchable& dispatchable);
    void replaySnapshot(const crdtp::Dispatchable& dispatchable);
    void snapshotCommandLog(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("compositingReasons"),
          &DomainDispatcherImpl::compositingReasons
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("loadSnapshot"),
          &DomainDispatcherImpl::loadSnapshot
    },
    {
          crdtp::SpanFrom("makeSnapshot"),
          &DomainDispatcherImpl::makeSnapshot
    },
    {
          crdtp::SpanFrom("profileSnapshot"),
          &DomainDispatcherImpl::profileSnapshot
    },
    {
          crdtp::SpanFrom("releaseSnapshot"),
          &DomainDispatcherImpl::releaseSnapshot
    },
    {
          crdtp::SpanFrom("replaySnapshot"),
          &DomainDispatcherImpl::replaySnapshot
    },
    {
          crdtp::SpanFrom("snapshotCommandLog"),
          &DomainDispatcherImpl::snapshotCommandLog
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct compositingReasonsParams : public crdtp::DeserializableProtocolObject<compositingReasonsParams> {
    String layerId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(compositingReasonsParams)
    CRDTP_DESERIALIZE_FIELD("layerId", layerId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::compositingReasons(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    compositingReasonsParams params;
    if (!compositingReasonsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_compositingReasons;
    std::unique_ptr<protocol::Array<String>> out_compositingReasonIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->compositingReasons(params.layerId, &out_compositingReasons, &out_compositingReasonIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.compositingReasons"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("compositingReasons"), out_compositingReasons);
          serializer.AddField(crdtp::MakeSpan("compositingReasonIds"), out_compositingReasonIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct loadSnapshotParams : public crdtp::DeserializableProtocolObject<loadSnapshotParams> {
    std::unique_ptr<protocol::Array<protocol::LayerTree::PictureTile>> tiles;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(loadSnapshotParams)
    CRDTP_DESERIALIZE_FIELD("tiles", tiles),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::loadSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    loadSnapshotParams params;
    if (!loadSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_snapshotId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->loadSnapshot(std::move(params.tiles), &out_snapshotId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.loadSnapshot"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("snapshotId"), out_snapshotId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct makeSnapshotParams : public crdtp::DeserializableProtocolObject<makeSnapshotParams> {
    String layerId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(makeSnapshotParams)
    CRDTP_DESERIALIZE_FIELD("layerId", layerId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::makeSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    makeSnapshotParams params;
    if (!makeSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_snapshotId;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->makeSnapshot(params.layerId, &out_snapshotId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.makeSnapshot"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("snapshotId"), out_snapshotId);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct profileSnapshotParams : public crdtp::DeserializableProtocolObject<profileSnapshotParams> {
    String snapshotId;
    std::optional<int> minRepeatCount;
    std::optional<double> minDuration;
    std::unique_ptr<protocol::DOM::Rect> clipRect;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(profileSnapshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("clipRect", clipRect),
    CRDTP_DESERIALIZE_FIELD_OPT("minDuration", minDuration),
    CRDTP_DESERIALIZE_FIELD_OPT("minRepeatCount", minRepeatCount),
    CRDTP_DESERIALIZE_FIELD("snapshotId", snapshotId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::profileSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    profileSnapshotParams params;
    if (!profileSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::Array<double>>> out_timings;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->profileSnapshot(params.snapshotId, std::move(params.minRepeatCount), std::move(params.minDuration), std::move(params.clipRect), &out_timings);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.profileSnapshot"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("timings"), out_timings);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct releaseSnapshotParams : public crdtp::DeserializableProtocolObject<releaseSnapshotParams> {
    String snapshotId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(releaseSnapshotParams)
    CRDTP_DESERIALIZE_FIELD("snapshotId", snapshotId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::releaseSnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    releaseSnapshotParams params;
    if (!releaseSnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->releaseSnapshot(params.snapshotId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.releaseSnapshot"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct replaySnapshotParams : public crdtp::DeserializableProtocolObject<replaySnapshotParams> {
    String snapshotId;
    std::optional<int> fromStep;
    std::optional<int> toStep;
    std::optional<double> scale;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(replaySnapshotParams)
    CRDTP_DESERIALIZE_FIELD_OPT("fromStep", fromStep),
    CRDTP_DESERIALIZE_FIELD_OPT("scale", scale),
    CRDTP_DESERIALIZE_FIELD("snapshotId", snapshotId),
    CRDTP_DESERIALIZE_FIELD_OPT("toStep", toStep),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::replaySnapshot(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    replaySnapshotParams params;
    if (!replaySnapshotParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_dataURL;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->replaySnapshot(params.snapshotId, std::move(params.fromStep), std::move(params.toStep), std::move(params.scale), &out_dataURL);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.replaySnapshot"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("dataURL"), out_dataURL);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct snapshotCommandLogParams : public crdtp::DeserializableProtocolObject<snapshotCommandLogParams> {
    String snapshotId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(snapshotCommandLogParams)
    CRDTP_DESERIALIZE_FIELD("snapshotId", snapshotId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::snapshotCommandLog(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    snapshotCommandLogParams params;
    if (!snapshotCommandLogParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::DictionaryValue>> out_commandLog;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->snapshotCommandLog(params.snapshotId, &out_commandLog);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("LayerTree.snapshotCommandLog"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("commandLog"), out_commandLog);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("LayerTree"), SortedRedirects(), std::move(dispatcher));
}

} // LayerTree
} // namespace blink
} // namespace protocol
