// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_FileSystem_h
#define blink_protocol_FileSystem_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/network.h"
#include "third_party/blink/renderer/core/inspector/protocol/storage.h"

namespace blink {
namespace protocol {
namespace FileSystem {
class File;
class Directory;
class BucketFileSystemLocator;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT File : public ::crdtp::ProtocolObject<File> {
public:
    ~File() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    double getLastModified() { return m_lastModified; }
    void setLastModified(double value);  // Defined below

    double getSize() { return m_size; }
    void setSize(double value);  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    template<int STATE>
    class FileBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            LastModifiedSet = 1 << 2,
            SizeSet = 1 << 3,
            TypeSet = 1 << 4,
            AllFieldsSet = (NameSet | LastModifiedSet | SizeSet | TypeSet | 0)};


        FileBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        FileBuilder<STATE | LastModifiedSet>& setLastModified(double value);  // Defined below

        FileBuilder<STATE | SizeSet>& setSize(double value);  // Defined below

        FileBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        std::unique_ptr<File> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class File;
        FileBuilder() : m_result(new File()) { }

        template<int STEP> FileBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<FileBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::FileSystem::File> m_result;
    };

    static FileBuilder<0> create()
    {
        return FileBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    File();  // Defined below

    String m_name;
    double m_lastModified;
    double m_size;
    String m_type;
};


class CORE_EXPORT Directory : public ::crdtp::ProtocolObject<Directory> {
public:
    ~Directory() override;  // Defined below

    String getName() { return m_name; }
    void setName(const String& value);  // Defined below

    protocol::Array<String>* getNestedDirectories() { return m_nestedDirectories.get(); }
    void setNestedDirectories(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    protocol::Array<protocol::FileSystem::File>* getNestedFiles() { return m_nestedFiles.get(); }
    void setNestedFiles(std::unique_ptr<protocol::Array<protocol::FileSystem::File>> value);  // Defined below

    template<int STATE>
    class DirectoryBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            NameSet = 1 << 1,
            NestedDirectoriesSet = 1 << 2,
            NestedFilesSet = 1 << 3,
            AllFieldsSet = (NameSet | NestedDirectoriesSet | NestedFilesSet | 0)};


        DirectoryBuilder<STATE | NameSet>& setName(const String& value);  // Defined below

        DirectoryBuilder<STATE | NestedDirectoriesSet>& setNestedDirectories(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        DirectoryBuilder<STATE | NestedFilesSet>& setNestedFiles(std::unique_ptr<protocol::Array<protocol::FileSystem::File>> value);  // Defined below

        std::unique_ptr<Directory> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Directory;
        DirectoryBuilder() : m_result(new Directory()) { }

        template<int STEP> DirectoryBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<DirectoryBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::FileSystem::Directory> m_result;
    };

    static DirectoryBuilder<0> create()
    {
        return DirectoryBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Directory();  // Defined below

    String m_name;
    std::unique_ptr<protocol::Array<String>> m_nestedDirectories;
    std::unique_ptr<protocol::Array<protocol::FileSystem::File>> m_nestedFiles;
};


class CORE_EXPORT BucketFileSystemLocator : public ::crdtp::ProtocolObject<BucketFileSystemLocator> {
public:
    ~BucketFileSystemLocator() override;  // Defined below

    String getStorageKey() { return m_storageKey; }
    void setStorageKey(const String& value);  // Defined below

    bool hasBucketName() { return !!m_bucketName; }
    String getBucketName(const String& defaultValue) const {
       return m_bucketName.value_or(defaultValue);
    }
    const std::optional<String>& getBucketName() const {
       return m_bucketName;
    }
    void setBucketName(const String& value);  // Defined below

    protocol::Array<String>* getPathComponents() { return m_pathComponents.get(); }
    void setPathComponents(std::unique_ptr<protocol::Array<String>> value);  // Defined below

    template<int STATE>
    class BucketFileSystemLocatorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StorageKeySet = 1 << 1,
            PathComponentsSet = 1 << 2,
            AllFieldsSet = (StorageKeySet | PathComponentsSet | 0)};


        BucketFileSystemLocatorBuilder<STATE | StorageKeySet>& setStorageKey(const String& value);  // Defined below

        BucketFileSystemLocatorBuilder<STATE>& setBucketName(const String& value);  // Defined below

        BucketFileSystemLocatorBuilder<STATE | PathComponentsSet>& setPathComponents(std::unique_ptr<protocol::Array<String>> value);  // Defined below

        std::unique_ptr<BucketFileSystemLocator> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class BucketFileSystemLocator;
        BucketFileSystemLocatorBuilder() : m_result(new BucketFileSystemLocator()) { }

        template<int STEP> BucketFileSystemLocatorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<BucketFileSystemLocatorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::FileSystem::BucketFileSystemLocator> m_result;
    };

    static BucketFileSystemLocatorBuilder<0> create()
    {
        return BucketFileSystemLocatorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    BucketFileSystemLocator();  // Defined below

    String m_storageKey;
    std::optional<String> m_bucketName;
    std::unique_ptr<protocol::Array<String>> m_pathComponents;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline File::~File() = default;
inline void File::setName(const String& value) { m_name = value; }
inline void File::setLastModified(double value) { m_lastModified = value; }
inline void File::setSize(double value) { m_size = value; }
inline void File::setType(const String& value) { m_type = value; }

template<int STATE>
inline File::FileBuilder<STATE | File::FileBuilder<STATE>::NameSet>&
File::FileBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline File::FileBuilder<STATE | File::FileBuilder<STATE>::LastModifiedSet>&
File::FileBuilder<STATE>::setLastModified(double value) {
  static_assert(!(STATE & LastModifiedSet), "property lastModified should not be set yet");
  m_result->setLastModified(value);
  return castState<LastModifiedSet>();
}
template<int STATE>
inline File::FileBuilder<STATE | File::FileBuilder<STATE>::SizeSet>&
File::FileBuilder<STATE>::setSize(double value) {
  static_assert(!(STATE & SizeSet), "property size should not be set yet");
  m_result->setSize(value);
  return castState<SizeSet>();
}
template<int STATE>
inline File::FileBuilder<STATE | File::FileBuilder<STATE>::TypeSet>&
File::FileBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}

inline File::File() {
  m_lastModified = 0;
  m_size = 0;
}
inline Directory::~Directory() = default;
inline void Directory::setName(const String& value) { m_name = value; }
inline void Directory::setNestedDirectories(std::unique_ptr<protocol::Array<String>> value) { m_nestedDirectories = std::move(value); }
inline void Directory::setNestedFiles(std::unique_ptr<protocol::Array<protocol::FileSystem::File>> value) { m_nestedFiles = std::move(value); }

template<int STATE>
inline Directory::DirectoryBuilder<STATE | Directory::DirectoryBuilder<STATE>::NameSet>&
Directory::DirectoryBuilder<STATE>::setName(const String& value) {
  static_assert(!(STATE & NameSet), "property name should not be set yet");
  m_result->setName(value);
  return castState<NameSet>();
}
template<int STATE>
inline Directory::DirectoryBuilder<STATE | Directory::DirectoryBuilder<STATE>::NestedDirectoriesSet>&
Directory::DirectoryBuilder<STATE>::setNestedDirectories(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & NestedDirectoriesSet), "property nestedDirectories should not be set yet");
  m_result->setNestedDirectories(std::move(value));
  return castState<NestedDirectoriesSet>();
}
template<int STATE>
inline Directory::DirectoryBuilder<STATE | Directory::DirectoryBuilder<STATE>::NestedFilesSet>&
Directory::DirectoryBuilder<STATE>::setNestedFiles(std::unique_ptr<protocol::Array<protocol::FileSystem::File>> value) {
  static_assert(!(STATE & NestedFilesSet), "property nestedFiles should not be set yet");
  m_result->setNestedFiles(std::move(value));
  return castState<NestedFilesSet>();
}

inline Directory::Directory() {
}
inline BucketFileSystemLocator::~BucketFileSystemLocator() = default;
inline void BucketFileSystemLocator::setStorageKey(const String& value) { m_storageKey = value; }
inline void BucketFileSystemLocator::setBucketName(const String& value) { m_bucketName = value; }
inline void BucketFileSystemLocator::setPathComponents(std::unique_ptr<protocol::Array<String>> value) { m_pathComponents = std::move(value); }

template<int STATE>
inline BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE | BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE>::StorageKeySet>&
BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE>::setStorageKey(const String& value) {
  static_assert(!(STATE & StorageKeySet), "property storageKey should not be set yet");
  m_result->setStorageKey(value);
  return castState<StorageKeySet>();
}
template<int STATE>
inline BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE>& BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE>::setBucketName(const String& value) {
  m_result->setBucketName(value);
  return *this;
}
template<int STATE>
inline BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE | BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE>::PathComponentsSet>&
BucketFileSystemLocator::BucketFileSystemLocatorBuilder<STATE>::setPathComponents(std::unique_ptr<protocol::Array<String>> value) {
  static_assert(!(STATE & PathComponentsSet), "property pathComponents should not be set yet");
  m_result->setPathComponents(std::move(value));
  return castState<PathComponentsSet>();
}

inline BucketFileSystemLocator::BucketFileSystemLocator() {
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    class CORE_EXPORT GetDirectoryCallback {
    public:
        virtual void sendSuccess(std::unique_ptr<protocol::FileSystem::Directory> directory) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~GetDirectoryCallback() { }
    };
    virtual void getDirectory(std::unique_ptr<protocol::FileSystem::BucketFileSystemLocator> in_bucketFileSystemLocator, std::unique_ptr<GetDirectoryCallback> callback) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace FileSystem
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_FileSystem_h)
