// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/dom_debugger.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace DOMDebugger {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "DOMDebugger";
const char Metainfo::commandPrefix[] = "DOMDebugger.";
const char Metainfo::version[] = "1.3";

namespace DOMBreakpointTypeEnum {
const char SubtreeModified[] = "subtree-modified";
const char AttributeModified[] = "attribute-modified";
const char NodeRemoved[] = "node-removed";
} // namespace DOMBreakpointTypeEnum


namespace CSPViolationTypeEnum {
const char TrustedtypeSinkViolation[] = "trustedtype-sink-violation";
const char TrustedtypePolicyViolation[] = "trustedtype-policy-violation";
} // namespace CSPViolationTypeEnum


CRDTP_BEGIN_DESERIALIZER(EventListener)
    CRDTP_DESERIALIZE_FIELD_OPT("backendNodeId", m_backendNodeId),
    CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("handler", m_handler),
    CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD("once", m_once),
    CRDTP_DESERIALIZE_FIELD_OPT("originalHandler", m_originalHandler),
    CRDTP_DESERIALIZE_FIELD("passive", m_passive),
    CRDTP_DESERIALIZE_FIELD("scriptId", m_scriptId),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD("useCapture", m_useCapture),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(EventListener)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("useCapture", m_useCapture);
    CRDTP_SERIALIZE_FIELD("passive", m_passive);
    CRDTP_SERIALIZE_FIELD("once", m_once);
    CRDTP_SERIALIZE_FIELD("scriptId", m_scriptId);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    CRDTP_SERIALIZE_FIELD("handler", m_handler);
    CRDTP_SERIALIZE_FIELD("originalHandler", m_originalHandler);
    CRDTP_SERIALIZE_FIELD("backendNodeId", m_backendNodeId);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void getEventListeners(const crdtp::Dispatchable& dispatchable);
    void removeDOMBreakpoint(const crdtp::Dispatchable& dispatchable);
    void removeEventListenerBreakpoint(const crdtp::Dispatchable& dispatchable);
    void removeXHRBreakpoint(const crdtp::Dispatchable& dispatchable);
    void setBreakOnCSPViolation(const crdtp::Dispatchable& dispatchable);
    void setDOMBreakpoint(const crdtp::Dispatchable& dispatchable);
    void setEventListenerBreakpoint(const crdtp::Dispatchable& dispatchable);
    void setXHRBreakpoint(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("getEventListeners"),
          &DomainDispatcherImpl::getEventListeners
    },
    {
          crdtp::SpanFrom("removeDOMBreakpoint"),
          &DomainDispatcherImpl::removeDOMBreakpoint
    },
    {
          crdtp::SpanFrom("removeEventListenerBreakpoint"),
          &DomainDispatcherImpl::removeEventListenerBreakpoint
    },
    {
          crdtp::SpanFrom("removeXHRBreakpoint"),
          &DomainDispatcherImpl::removeXHRBreakpoint
    },
    {
          crdtp::SpanFrom("setBreakOnCSPViolation"),
          &DomainDispatcherImpl::setBreakOnCSPViolation
    },
    {
          crdtp::SpanFrom("setDOMBreakpoint"),
          &DomainDispatcherImpl::setDOMBreakpoint
    },
    {
          crdtp::SpanFrom("setEventListenerBreakpoint"),
          &DomainDispatcherImpl::setEventListenerBreakpoint
    },
    {
          crdtp::SpanFrom("setXHRBreakpoint"),
          &DomainDispatcherImpl::setXHRBreakpoint
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct getEventListenersParams : public crdtp::DeserializableProtocolObject<getEventListenersParams> {
    String objectId;
    std::optional<int> depth;
    std::optional<bool> pierce;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getEventListenersParams)
    CRDTP_DESERIALIZE_FIELD_OPT("depth", depth),
    CRDTP_DESERIALIZE_FIELD("objectId", objectId),
    CRDTP_DESERIALIZE_FIELD_OPT("pierce", pierce),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getEventListeners(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getEventListenersParams params;
    if (!getEventListenersParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>> out_listeners;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getEventListeners(params.objectId, std::move(params.depth), std::move(params.pierce), &out_listeners);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.getEventListeners"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("listeners"), out_listeners);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct removeDOMBreakpointParams : public crdtp::DeserializableProtocolObject<removeDOMBreakpointParams> {
    int nodeId;
    String type;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeDOMBreakpointParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("type", type),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeDOMBreakpoint(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeDOMBreakpointParams params;
    if (!removeDOMBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeDOMBreakpoint(params.nodeId, params.type);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.removeDOMBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeEventListenerBreakpointParams : public crdtp::DeserializableProtocolObject<removeEventListenerBreakpointParams> {
    String eventName;
    std::optional<String> targetName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeEventListenerBreakpointParams)
    CRDTP_DESERIALIZE_FIELD("eventName", eventName),
    CRDTP_DESERIALIZE_FIELD_OPT("targetName", targetName),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeEventListenerBreakpoint(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeEventListenerBreakpointParams params;
    if (!removeEventListenerBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeEventListenerBreakpoint(params.eventName, std::move(params.targetName));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.removeEventListenerBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct removeXHRBreakpointParams : public crdtp::DeserializableProtocolObject<removeXHRBreakpointParams> {
    String url;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(removeXHRBreakpointParams)
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::removeXHRBreakpoint(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    removeXHRBreakpointParams params;
    if (!removeXHRBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->removeXHRBreakpoint(params.url);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.removeXHRBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBreakOnCSPViolationParams : public crdtp::DeserializableProtocolObject<setBreakOnCSPViolationParams> {
    std::unique_ptr<protocol::Array<String>> violationTypes;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setBreakOnCSPViolationParams)
    CRDTP_DESERIALIZE_FIELD("violationTypes", violationTypes),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBreakOnCSPViolation(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBreakOnCSPViolationParams params;
    if (!setBreakOnCSPViolationParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBreakOnCSPViolation(std::move(params.violationTypes));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.setBreakOnCSPViolation"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setDOMBreakpointParams : public crdtp::DeserializableProtocolObject<setDOMBreakpointParams> {
    int nodeId;
    String type;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setDOMBreakpointParams)
    CRDTP_DESERIALIZE_FIELD("nodeId", nodeId),
    CRDTP_DESERIALIZE_FIELD("type", type),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setDOMBreakpoint(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setDOMBreakpointParams params;
    if (!setDOMBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setDOMBreakpoint(params.nodeId, params.type);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.setDOMBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setEventListenerBreakpointParams : public crdtp::DeserializableProtocolObject<setEventListenerBreakpointParams> {
    String eventName;
    std::optional<String> targetName;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setEventListenerBreakpointParams)
    CRDTP_DESERIALIZE_FIELD("eventName", eventName),
    CRDTP_DESERIALIZE_FIELD_OPT("targetName", targetName),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setEventListenerBreakpoint(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setEventListenerBreakpointParams params;
    if (!setEventListenerBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setEventListenerBreakpoint(params.eventName, std::move(params.targetName));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.setEventListenerBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setXHRBreakpointParams : public crdtp::DeserializableProtocolObject<setXHRBreakpointParams> {
    String url;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setXHRBreakpointParams)
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setXHRBreakpoint(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setXHRBreakpointParams params;
    if (!setXHRBreakpointParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setXHRBreakpoint(params.url);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("DOMDebugger.setXHRBreakpoint"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("DOMDebugger.removeInstrumentationBreakpoint"), crdtp::SpanFrom("EventBreakpoints.removeInstrumentationBreakpoint") },
          { crdtp::SpanFrom("DOMDebugger.setInstrumentationBreakpoint"), crdtp::SpanFrom("EventBreakpoints.setInstrumentationBreakpoint") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("DOMDebugger"), SortedRedirects(), std::move(dispatcher));
}

} // DOMDebugger
} // namespace blink
} // namespace protocol
