// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_WEBGL_LAYER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_WEBGL_LAYER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT XRWebGLLayerInit : public bindings::InputDictionaryBase {
  
  public:
static XRWebGLLayerInit* Create() {
  return MakeGarbageCollected<XRWebGLLayerInit>();
}
static XRWebGLLayerInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRWebGLLayerInit>(isolate);
}
static XRWebGLLayerInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRWebGLLayerInit();
explicit  XRWebGLLayerInit(v8::Isolate* isolate);

bool hasAlpha() const {
  return true;
}
bool alpha() const {
  return member_alpha_;
}
void setAlpha(bool value) {
  member_alpha_ = value;
}

bool hasAntialias() const {
  return true;
}
bool antialias() const {
  return member_antialias_;
}
void setAntialias(bool value) {
  member_antialias_ = value;
}

bool hasDepth() const {
  return true;
}
bool depth() const {
  return member_depth_;
}
void setDepth(bool value) {
  member_depth_ = value;
}

bool hasFramebufferScaleFactor() const {
  return true;
}
double framebufferScaleFactor() const {
  return member_framebuffer_scale_factor_;
}
void setFramebufferScaleFactor(double value) {
  member_framebuffer_scale_factor_ = value;
}

bool hasIgnoreDepthValues() const {
  return true;
}
bool ignoreDepthValues() const {
  return member_ignore_depth_values_;
}
void setIgnoreDepthValues(bool value) {
  member_ignore_depth_values_ = value;
}

bool hasMultiview() const {
  return true;
}
bool multiview() const {
  return member_multiview_;
}
void setMultiview(bool value) {
  member_multiview_ = value;
}

bool hasStencil() const {
  return true;
}
bool stencil() const {
  return member_stencil_;
}
void setStencil(bool value) {
  member_stencil_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_alpha_{true};
bool member_antialias_{true};
bool member_depth_{true};
double member_framebuffer_scale_factor_{1.0};
bool member_ignore_depth_values_{false};
bool member_multiview_{false};
bool member_stencil_{false};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_WEBGL_LAYER_INIT_H_
