// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_VISIBILITY_MASK_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_VISIBILITY_MASK_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_eye.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class XRSession;

class MODULES_EXPORT XRVisibilityMaskChangeEventInit : public EventInit {
  
  public:
static XRVisibilityMaskChangeEventInit* Create() {
  return MakeGarbageCollected<XRVisibilityMaskChangeEventInit>();
}
static XRVisibilityMaskChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRVisibilityMaskChangeEventInit>(isolate);
}
static XRVisibilityMaskChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRVisibilityMaskChangeEventInit();
explicit  XRVisibilityMaskChangeEventInit(v8::Isolate* isolate);

bool hasEye() const {
  return true;
}
V8XREye eye() const {
  return member_eye_;
}
void setEye(V8XREye value) {
  member_eye_ = value;
}
void setEye(V8XREye::Enum value) {
  member_eye_ = V8XREye(value);
}

bool hasIndex() const {
  return true;
}
uint32_t index() const {
  return member_index_;
}
void setIndex(uint32_t value) {
  member_index_ = value;
}

bool hasIndices() const {
  return true;
}
NotShared<DOMUint32Array> indices() const {
  return member_indices_;
}
void setIndices(NotShared<DOMUint32Array> value) {
  member_indices_ = value;
DCHECK(member_indices_);
}

bool hasSession() const {
  return true;
}
XRSession* session() const {
  return member_session_.Get();
}
void setSession(XRSession* value) {
  member_session_ = value;
DCHECK(member_session_);
}

bool hasVertices() const {
  return true;
}
NotShared<DOMFloat32Array> vertices() const {
  return member_vertices_;
}
void setVertices(NotShared<DOMFloat32Array> value) {
  member_vertices_ = value;
DCHECK(member_vertices_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8XREye member_eye_{static_cast<V8XREye::Enum>(0)};
uint32_t member_index_;
NotShared<DOMUint32Array> member_indices_;
Member<XRSession> member_session_;
NotShared<DOMFloat32Array> member_vertices_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_VISIBILITY_MASK_CHANGE_EVENT_INIT_H_
