// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_session_init.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_depth_state_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_dom_overlay_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_tracked_image_init.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"depthSensing",
"domOverlay",
"optionalFeatures",
"requiredFeatures",
"trackedImages",
};


}  // namespace 

XRSessionInit* XRSessionInit::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  XRSessionInit* dictionary = MakeGarbageCollected<XRSessionInit>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "XRSessionInit";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 XRSessionInit::XRSessionInit() {
  
}

 XRSessionInit::XRSessionInit(v8::Isolate* isolate) {
  
}

















Vector<String> XRSessionInit::getOptionalFeaturesOr(const Vector<String>& fallback_value) const {
  if (!hasOptionalFeatures()) {
  return fallback_value;
}
return member_optional_features_;
}

Vector<String> XRSessionInit::getOptionalFeaturesOr(Vector<String>&& fallback_value) const {
  if (!hasOptionalFeatures()) {
  return std::move(fallback_value);
}
return member_optional_features_;
}

void XRSessionInit::setOptionalFeatures(const Vector<String>& value) {
  member_optional_features_ = value;
has_optional_features_ = true;
}

void XRSessionInit::setOptionalFeatures(Vector<String>&& value) {
  member_optional_features_ = std::move(value);
has_optional_features_ = true;
}




Vector<String> XRSessionInit::getRequiredFeaturesOr(const Vector<String>& fallback_value) const {
  if (!hasRequiredFeatures()) {
  return fallback_value;
}
return member_required_features_;
}

Vector<String> XRSessionInit::getRequiredFeaturesOr(Vector<String>&& fallback_value) const {
  if (!hasRequiredFeatures()) {
  return std::move(fallback_value);
}
return member_required_features_;
}

void XRSessionInit::setRequiredFeatures(const Vector<String>& value) {
  member_required_features_ = value;
has_required_features_ = true;
}

void XRSessionInit::setRequiredFeatures(Vector<String>&& value) {
  member_required_features_ = std::move(value);
has_required_features_ = true;
}




HeapVector<Member<XRTrackedImageInit>> XRSessionInit::getTrackedImagesOr(const HeapVector<Member<XRTrackedImageInit>>& fallback_value) const {
  if (!hasTrackedImages()) {
  return fallback_value;
}
return member_tracked_images_;
}

HeapVector<Member<XRTrackedImageInit>> XRSessionInit::getTrackedImagesOr(HeapVector<Member<XRTrackedImageInit>>&& fallback_value) const {
  if (!hasTrackedImages()) {
  return std::move(fallback_value);
}
return member_tracked_images_;
}

void XRSessionInit::setTrackedImages(const HeapVector<Member<XRTrackedImageInit>>& value) {
  member_tracked_images_ = value;
has_tracked_images_ = true;
}

void XRSessionInit::setTrackedImages(HeapVector<Member<XRTrackedImageInit>>&& value) {
  member_tracked_images_ = std::move(value);
has_tracked_images_ = true;
}



void XRSessionInit::Trace(Visitor* visitor) const {
  visitor->Trace(member_depth_sensing_);
visitor->Trace(member_dom_overlay_);
visitor->Trace(member_tracked_images_);
bindings::InputDictionaryBase::Trace(visitor);
}

void XRSessionInit::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "XRSessionInit";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("depthSensing");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<XRDepthStateInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_depth_sensing_, member_depth_sensing_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("domOverlay");
if (!bindings::GetDictionaryMemberFromV8Object<XRDOMOverlayInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_dom_overlay_, member_dom_overlay_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("optionalFeatures");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_optional_features_, member_optional_features_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requiredFeatures");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_required_features_, member_required_features_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::WebXRImageTrackingEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("trackedImages");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<XRTrackedImageInit>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_tracked_images_, member_tracked_images_, class_like_name, exception_state)) {
  return;
}
}
}

const base::span<const v8::Eternal<v8::Name>> XRSessionInit::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
