// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_CUBE_LAYER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_CUBE_LAYER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_xr_layer_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMPointReadOnly;
class ExceptionState;

class MODULES_EXPORT XRCubeLayerInit : public XRLayerInit {
  
  public:
static XRCubeLayerInit* Create() {
  return MakeGarbageCollected<XRCubeLayerInit>();
}
static XRCubeLayerInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<XRCubeLayerInit>(isolate);
}
static XRCubeLayerInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  XRCubeLayerInit();
explicit  XRCubeLayerInit(v8::Isolate* isolate);

bool hasOrientation() const {
  return has_orientation_;
}
DOMPointReadOnly* orientation() const {
  DCHECK(hasOrientation());
return member_orientation_.Get();
}
DOMPointReadOnly* getOrientationOr(DOMPointReadOnly* fallback_value) const {
  if (!hasOrientation()) {
  return fallback_value;
}
return member_orientation_.Get();
}
void setOrientation(DOMPointReadOnly* value) {
  member_orientation_ = value;
has_orientation_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = XRLayerInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_orientation_ = false;

Member<DOMPointReadOnly> member_orientation_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_XR_CUBE_LAYER_INIT_H_
