// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WRITE_PARAMS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WRITE_PARAMS_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_write_command_type.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class Blob;
class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;
class V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString;

class MODULES_EXPORT WriteParams : public bindings::DictionaryBase {
  
  public:
static WriteParams* Create() {
  return MakeGarbageCollected<WriteParams>();
}
static WriteParams* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WriteParams>(isolate);
}
static WriteParams* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WriteParams();
explicit  WriteParams(v8::Isolate* isolate);

bool hasData() const {
  return has_data_;
}
V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* data() const {
  DCHECK(hasData());
return member_data_.Get();
}
V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* getDataOr(V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* fallback_value) const {
  if (!hasData()) {
  return fallback_value;
}
return member_data_.Get();
}
void setData(V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString* value) {
  member_data_ = value;
has_data_ = true;
}

bool hasPosition() const {
  return has_position_;
}
const std::optional<uint64_t>& position() const {
  DCHECK(hasPosition());
return member_position_;
}
std::optional<uint64_t> getPositionOr(const std::optional<uint64_t>& fallback_value) const {
  if (!hasPosition()) {
  return fallback_value;
}
return member_position_;
}
void setPosition(const std::optional<uint64_t>& value) {
  member_position_ = value;
has_position_ = true;
}
void setPosition(uint64_t value) {
  member_position_ = value;
has_position_ = true;
}

bool hasSize() const {
  return has_size_;
}
const std::optional<uint64_t>& size() const {
  DCHECK(hasSize());
return member_size_;
}
std::optional<uint64_t> getSizeOr(const std::optional<uint64_t>& fallback_value) const {
  if (!hasSize()) {
  return fallback_value;
}
return member_size_;
}
void setSize(const std::optional<uint64_t>& value) {
  member_size_ = value;
has_size_ = true;
}
void setSize(uint64_t value) {
  member_size_ = value;
has_size_ = true;
}

bool hasType() const {
  return true;
}
V8WriteCommandType type() const {
  return member_type_;
}
void setType(V8WriteCommandType value) {
  member_type_ = value;
}
void setType(V8WriteCommandType::Enum value) {
  member_type_ = V8WriteCommandType(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_data_ = false;
bool has_position_ = false;
bool has_size_ = false;

Member<V8UnionArrayBufferOrArrayBufferViewOrBlobOrUSVString> member_data_;
std::optional<uint64_t> member_position_;
std::optional<uint64_t> member_size_;
V8WriteCommandType member_type_{static_cast<V8WriteCommandType::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WRITE_PARAMS_H_
