// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WINDOW_CONTROLS_OVERLAY_GEOMETRY_CHANGE_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WINDOW_CONTROLS_OVERLAY_GEOMETRY_CHANGE_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class DOMRect;
class ExceptionState;

class MODULES_EXPORT WindowControlsOverlayGeometryChangeEventInit : public EventInit {
  
  public:
static WindowControlsOverlayGeometryChangeEventInit* Create() {
  return MakeGarbageCollected<WindowControlsOverlayGeometryChangeEventInit>();
}
static WindowControlsOverlayGeometryChangeEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WindowControlsOverlayGeometryChangeEventInit>(isolate);
}
static WindowControlsOverlayGeometryChangeEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WindowControlsOverlayGeometryChangeEventInit();
explicit  WindowControlsOverlayGeometryChangeEventInit(v8::Isolate* isolate);

bool hasTitlebarAreaRect() const {
  return true;
}
DOMRect* titlebarAreaRect() const {
  return member_titlebar_area_rect_.Get();
}
void setTitlebarAreaRect(DOMRect* value) {
  member_titlebar_area_rect_ = value;
DCHECK(member_titlebar_area_rect_);
}

bool hasVisible() const {
  return true;
}
bool visible() const {
  return member_visible_;
}
void setVisible(bool value) {
  member_visible_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = EventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<DOMRect> member_titlebar_area_rect_;
bool member_visible_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WINDOW_CONTROLS_OVERLAY_GEOMETRY_CHANGE_EVENT_INIT_H_
