// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_draw_instanced_base_vertex_base_instance.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/modules/webgl/webgl_draw_instanced_base_vertex_base_instance.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"

namespace blink {



bool V8WebGLDrawInstancedBaseVertexBaseInstance::IsExposed(ExecutionContext* execution_context) {
  return false;
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLDrawInstancedBaseVertexBaseInstance::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLDrawInstancedBaseVertexBaseInstance::InstallInterfaceTemplate,
    V8WebGLDrawInstancedBaseVertexBaseInstance::InstallContextDependentProperties,
    "WebGLDrawInstancedBaseVertexBaseInstance",
    nullptr,
    V8WebGLDrawInstancedBaseVertexBaseInstance::kThisTag,
    V8WebGLDrawInstancedBaseVertexBaseInstance::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLDrawInstancedBaseVertexBaseInstance::wrapper_type_info_ =
    V8WebGLDrawInstancedBaseVertexBaseInstance::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, WebGLDrawInstancedBaseVertexBaseInstance>::value,
    "WebGLDrawInstancedBaseVertexBaseInstance inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_draw_instanced_base_vertex_base_instance {

void DrawArraysInstancedBaseInstanceWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLDrawInstancedBaseVertexBaseInstance_drawArraysInstancedBaseInstanceWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLDrawInstancedBaseVertexBaseInstance.drawArraysInstancedBaseInstanceWEBGL");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLDrawInstancedBaseVertexBaseInstance* blink_receiver = V8WebGLDrawInstancedBaseVertexBaseInstance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_first = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_instance_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_baseinstance = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawArraysInstancedBaseInstanceWEBGL(arg1_mode, arg2_first, arg3_count, arg4_instance_count, arg5_baseinstance);

}

void DrawElementsInstancedBaseVertexBaseInstanceWEBGLOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLDrawInstancedBaseVertexBaseInstance_drawElementsInstancedBaseVertexBaseInstanceWEBGL");
BLINK_BINDINGS_TRACE_EVENT("WebGLDrawInstancedBaseVertexBaseInstance.drawElementsInstancedBaseVertexBaseInstanceWEBGL");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLDrawInstancedBaseVertexBaseInstance* blink_receiver = V8WebGLDrawInstancedBaseVertexBaseInstance::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_offset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_instance_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_basevertex = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_baseinstance = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawElementsInstancedBaseVertexBaseInstanceWEBGL(arg1_mode, arg2_count, arg3_type, arg4_offset, arg5_instance_count, arg6_basevertex, arg7_baseinstance);

}


}  // namespace v8_webgl_draw_instanced_base_vertex_base_instance

using namespace v8_webgl_draw_instanced_base_vertex_base_instance;

}  // namespace 

void V8WebGLDrawInstancedBaseVertexBaseInstance::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLDrawInstancedBaseVertexBaseInstance::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLDrawInstancedBaseVertexBaseInstance::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"drawArraysInstancedBaseInstanceWEBGL", DrawArraysInstancedBaseInstanceWEBGLOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawElementsInstancedBaseVertexBaseInstanceWEBGL", DrawElementsInstancedBaseVertexBaseInstanceWEBGLOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLDrawInstancedBaseVertexBaseInstance", kOperationTable);
}



}


void V8WebGLDrawInstancedBaseVertexBaseInstance::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (feature_selector.IsAll()) {
  v8::Isolate* isolate = v8::Isolate::GetCurrent();
// [LegacyNoInterfaceObject]
// 3.7.3. Interface prototype object
// https://webidl.spec.whatwg.org/#interface-prototype-object
// step 13. If the [LegacyNoInterfaceObject] extended attribute was not
//   specified on interface, then:
//
// V8 defines "constructor" property on the prototype object by default.
prototype_object->Delete(
    context, V8AtomicString(isolate, "constructor")).ToChecked();

}







}


}  // namespace blink
