// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_DATAGRAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_DATAGRAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT WebTransportDatagramStats : public bindings::DictionaryBase {
  
  public:
static WebTransportDatagramStats* Create() {
  return MakeGarbageCollected<WebTransportDatagramStats>();
}
static WebTransportDatagramStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WebTransportDatagramStats>(isolate);
}
static WebTransportDatagramStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WebTransportDatagramStats();
explicit  WebTransportDatagramStats(v8::Isolate* isolate);

bool hasDroppedIncoming() const {
  return has_dropped_incoming_;
}
uint64_t droppedIncoming() const {
  DCHECK(hasDroppedIncoming());
return member_dropped_incoming_;
}
uint64_t getDroppedIncomingOr(uint64_t fallback_value) const {
  if (!hasDroppedIncoming()) {
  return fallback_value;
}
return member_dropped_incoming_;
}
void setDroppedIncoming(uint64_t value) {
  member_dropped_incoming_ = value;
has_dropped_incoming_ = true;
}

bool hasExpiredOutgoing() const {
  return has_expired_outgoing_;
}
uint64_t expiredOutgoing() const {
  DCHECK(hasExpiredOutgoing());
return member_expired_outgoing_;
}
uint64_t getExpiredOutgoingOr(uint64_t fallback_value) const {
  if (!hasExpiredOutgoing()) {
  return fallback_value;
}
return member_expired_outgoing_;
}
void setExpiredOutgoing(uint64_t value) {
  member_expired_outgoing_ = value;
has_expired_outgoing_ = true;
}

bool hasLostOutgoing() const {
  return has_lost_outgoing_;
}
uint64_t lostOutgoing() const {
  DCHECK(hasLostOutgoing());
return member_lost_outgoing_;
}
uint64_t getLostOutgoingOr(uint64_t fallback_value) const {
  if (!hasLostOutgoing()) {
  return fallback_value;
}
return member_lost_outgoing_;
}
void setLostOutgoing(uint64_t value) {
  member_lost_outgoing_ = value;
has_lost_outgoing_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_dropped_incoming_ = false;
bool has_expired_outgoing_ = false;
bool has_lost_outgoing_ = false;

uint64_t member_dropped_incoming_;
uint64_t member_expired_outgoing_;
uint64_t member_lost_outgoing_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WEB_TRANSPORT_DATAGRAM_STATS_H_
