// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printer_state_reason.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"

namespace blink {



constexpr const char* const V8WebPrinterStateReason::string_table_[] = {
"none", "other", "connecting-to-device", "cover-open", "developer-empty", "developer-low", "door-open", "fuser-over-temp", "fuser-under-temp", "input-tray-missing", "interlock-open", "interpreter-resource-unavailable", "marker-supply-empty", "marker-supply-low", "marker-waste-almost-full", "marker-waste-full", "media-empty", "media-jam", "media-low", "media-needed", "moving-to-paused", "opc-life-over", "opc-near-eol", "output-area-almost-full", "output-area-full", "output-tray-missing", "paused", "shutdown", "spool-area-full", "stopped-partly", "stopping", "timed-out", "toner-empty", "toner-low", "cups-pki-expired"
};

V8WebPrinterStateReason V8WebPrinterStateReason::Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state) {
  const auto& result = bindings::FindIndexInEnumStringTable(isolate, value, string_table_, "WebPrinterStateReason", exception_state);
return result.has_value() ? V8WebPrinterStateReason(static_cast<Enum>(result.value())) : V8WebPrinterStateReason();
}

std::optional<V8WebPrinterStateReason> V8WebPrinterStateReason::Create(const String& value) {
  const auto& result = bindings::FindIndexInEnumStringTable(value, string_table_);
if (!result)
  return std::nullopt;
return V8WebPrinterStateReason(static_cast<Enum>(result.value()));
}


static_assert(std::is_trivially_copyable<V8WebPrinterStateReason>::value, "");






}  // namespace blink
