// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printer_attributes.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_media_collection.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_range.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_web_printing_resolution.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"copiesDefault",
"copiesSupported",
"documentFormatDefault",
"documentFormatSupported",
"mediaColDatabase",
"mediaColDefault",
"mediaSourceDefault",
"mediaSourceSupported",
"multipleDocumentHandlingDefault",
"multipleDocumentHandlingSupported",
"orientationRequestedDefault",
"orientationRequestedSupported",
"printColorModeDefault",
"printColorModeSupported",
"printQualityDefault",
"printQualitySupported",
"printerId",
"printerName",
"printerResolutionDefault",
"printerResolutionSupported",
"printerState",
"printerStateMessage",
"printerStateReasons",
"sidesDefault",
"sidesSupported",
};


}  // namespace 

WebPrinterAttributes* WebPrinterAttributes::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WebPrinterAttributes* dictionary = MakeGarbageCollected<WebPrinterAttributes>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WebPrinterAttributes";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WebPrinterAttributes::WebPrinterAttributes() {
  
}

 WebPrinterAttributes::WebPrinterAttributes(v8::Isolate* isolate) {
  
}
























Vector<V8WebPrintingMimeMediaType> WebPrinterAttributes::getDocumentFormatSupportedOr(const Vector<V8WebPrintingMimeMediaType>& fallback_value) const {
  if (!hasDocumentFormatSupported()) {
  return fallback_value;
}
return member_document_format_supported_;
}

Vector<V8WebPrintingMimeMediaType> WebPrinterAttributes::getDocumentFormatSupportedOr(Vector<V8WebPrintingMimeMediaType>&& fallback_value) const {
  if (!hasDocumentFormatSupported()) {
  return std::move(fallback_value);
}
return member_document_format_supported_;
}

void WebPrinterAttributes::setDocumentFormatSupported(const Vector<V8WebPrintingMimeMediaType>& value) {
  member_document_format_supported_ = value;
has_document_format_supported_ = true;
}

void WebPrinterAttributes::setDocumentFormatSupported(Vector<V8WebPrintingMimeMediaType>&& value) {
  member_document_format_supported_ = std::move(value);
has_document_format_supported_ = true;
}




HeapVector<Member<WebPrintingMediaCollection>> WebPrinterAttributes::getMediaColDatabaseOr(const HeapVector<Member<WebPrintingMediaCollection>>& fallback_value) const {
  if (!hasMediaColDatabase()) {
  return fallback_value;
}
return member_media_col_database_;
}

HeapVector<Member<WebPrintingMediaCollection>> WebPrinterAttributes::getMediaColDatabaseOr(HeapVector<Member<WebPrintingMediaCollection>>&& fallback_value) const {
  if (!hasMediaColDatabase()) {
  return std::move(fallback_value);
}
return member_media_col_database_;
}

void WebPrinterAttributes::setMediaColDatabase(const HeapVector<Member<WebPrintingMediaCollection>>& value) {
  member_media_col_database_ = value;
has_media_col_database_ = true;
}

void WebPrinterAttributes::setMediaColDatabase(HeapVector<Member<WebPrintingMediaCollection>>&& value) {
  member_media_col_database_ = std::move(value);
has_media_col_database_ = true;
}











String WebPrinterAttributes::getMediaSourceDefaultOr(const String& fallback_value) const {
  if (!hasMediaSourceDefault()) {
  return fallback_value;
}
return member_media_source_default_;
}

String WebPrinterAttributes::getMediaSourceDefaultOr(String&& fallback_value) const {
  if (!hasMediaSourceDefault()) {
  return std::move(fallback_value);
}
return member_media_source_default_;
}

void WebPrinterAttributes::setMediaSourceDefault(const String& value) {
  member_media_source_default_ = value;
has_media_source_default_ = true;
}

void WebPrinterAttributes::setMediaSourceDefault(String&& value) {
  member_media_source_default_ = std::move(value);
has_media_source_default_ = true;
}




Vector<String> WebPrinterAttributes::getMediaSourceSupportedOr(const Vector<String>& fallback_value) const {
  if (!hasMediaSourceSupported()) {
  return fallback_value;
}
return member_media_source_supported_;
}

Vector<String> WebPrinterAttributes::getMediaSourceSupportedOr(Vector<String>&& fallback_value) const {
  if (!hasMediaSourceSupported()) {
  return std::move(fallback_value);
}
return member_media_source_supported_;
}

void WebPrinterAttributes::setMediaSourceSupported(const Vector<String>& value) {
  member_media_source_supported_ = value;
has_media_source_supported_ = true;
}

void WebPrinterAttributes::setMediaSourceSupported(Vector<String>&& value) {
  member_media_source_supported_ = std::move(value);
has_media_source_supported_ = true;
}











Vector<V8WebPrintingMultipleDocumentHandling> WebPrinterAttributes::getMultipleDocumentHandlingSupportedOr(const Vector<V8WebPrintingMultipleDocumentHandling>& fallback_value) const {
  if (!hasMultipleDocumentHandlingSupported()) {
  return fallback_value;
}
return member_multiple_document_handling_supported_;
}

Vector<V8WebPrintingMultipleDocumentHandling> WebPrinterAttributes::getMultipleDocumentHandlingSupportedOr(Vector<V8WebPrintingMultipleDocumentHandling>&& fallback_value) const {
  if (!hasMultipleDocumentHandlingSupported()) {
  return std::move(fallback_value);
}
return member_multiple_document_handling_supported_;
}

void WebPrinterAttributes::setMultipleDocumentHandlingSupported(const Vector<V8WebPrintingMultipleDocumentHandling>& value) {
  member_multiple_document_handling_supported_ = value;
has_multiple_document_handling_supported_ = true;
}

void WebPrinterAttributes::setMultipleDocumentHandlingSupported(Vector<V8WebPrintingMultipleDocumentHandling>&& value) {
  member_multiple_document_handling_supported_ = std::move(value);
has_multiple_document_handling_supported_ = true;
}











Vector<V8WebPrintingOrientationRequested> WebPrinterAttributes::getOrientationRequestedSupportedOr(const Vector<V8WebPrintingOrientationRequested>& fallback_value) const {
  if (!hasOrientationRequestedSupported()) {
  return fallback_value;
}
return member_orientation_requested_supported_;
}

Vector<V8WebPrintingOrientationRequested> WebPrinterAttributes::getOrientationRequestedSupportedOr(Vector<V8WebPrintingOrientationRequested>&& fallback_value) const {
  if (!hasOrientationRequestedSupported()) {
  return std::move(fallback_value);
}
return member_orientation_requested_supported_;
}

void WebPrinterAttributes::setOrientationRequestedSupported(const Vector<V8WebPrintingOrientationRequested>& value) {
  member_orientation_requested_supported_ = value;
has_orientation_requested_supported_ = true;
}

void WebPrinterAttributes::setOrientationRequestedSupported(Vector<V8WebPrintingOrientationRequested>&& value) {
  member_orientation_requested_supported_ = std::move(value);
has_orientation_requested_supported_ = true;
}











Vector<V8WebPrintColorMode> WebPrinterAttributes::getPrintColorModeSupportedOr(const Vector<V8WebPrintColorMode>& fallback_value) const {
  if (!hasPrintColorModeSupported()) {
  return fallback_value;
}
return member_print_color_mode_supported_;
}

Vector<V8WebPrintColorMode> WebPrinterAttributes::getPrintColorModeSupportedOr(Vector<V8WebPrintColorMode>&& fallback_value) const {
  if (!hasPrintColorModeSupported()) {
  return std::move(fallback_value);
}
return member_print_color_mode_supported_;
}

void WebPrinterAttributes::setPrintColorModeSupported(const Vector<V8WebPrintColorMode>& value) {
  member_print_color_mode_supported_ = value;
has_print_color_mode_supported_ = true;
}

void WebPrinterAttributes::setPrintColorModeSupported(Vector<V8WebPrintColorMode>&& value) {
  member_print_color_mode_supported_ = std::move(value);
has_print_color_mode_supported_ = true;
}











Vector<V8WebPrintQuality> WebPrinterAttributes::getPrintQualitySupportedOr(const Vector<V8WebPrintQuality>& fallback_value) const {
  if (!hasPrintQualitySupported()) {
  return fallback_value;
}
return member_print_quality_supported_;
}

Vector<V8WebPrintQuality> WebPrinterAttributes::getPrintQualitySupportedOr(Vector<V8WebPrintQuality>&& fallback_value) const {
  if (!hasPrintQualitySupported()) {
  return std::move(fallback_value);
}
return member_print_quality_supported_;
}

void WebPrinterAttributes::setPrintQualitySupported(const Vector<V8WebPrintQuality>& value) {
  member_print_quality_supported_ = value;
has_print_quality_supported_ = true;
}

void WebPrinterAttributes::setPrintQualitySupported(Vector<V8WebPrintQuality>&& value) {
  member_print_quality_supported_ = std::move(value);
has_print_quality_supported_ = true;
}




String WebPrinterAttributes::getPrinterIdOr(const String& fallback_value) const {
  if (!hasPrinterId()) {
  return fallback_value;
}
return member_printer_id_;
}

String WebPrinterAttributes::getPrinterIdOr(String&& fallback_value) const {
  if (!hasPrinterId()) {
  return std::move(fallback_value);
}
return member_printer_id_;
}

void WebPrinterAttributes::setPrinterId(const String& value) {
  member_printer_id_ = value;
has_printer_id_ = true;
}

void WebPrinterAttributes::setPrinterId(String&& value) {
  member_printer_id_ = std::move(value);
has_printer_id_ = true;
}




String WebPrinterAttributes::getPrinterNameOr(const String& fallback_value) const {
  if (!hasPrinterName()) {
  return fallback_value;
}
return member_printer_name_;
}

String WebPrinterAttributes::getPrinterNameOr(String&& fallback_value) const {
  if (!hasPrinterName()) {
  return std::move(fallback_value);
}
return member_printer_name_;
}

void WebPrinterAttributes::setPrinterName(const String& value) {
  member_printer_name_ = value;
has_printer_name_ = true;
}

void WebPrinterAttributes::setPrinterName(String&& value) {
  member_printer_name_ = std::move(value);
has_printer_name_ = true;
}











HeapVector<Member<WebPrintingResolution>> WebPrinterAttributes::getPrinterResolutionSupportedOr(const HeapVector<Member<WebPrintingResolution>>& fallback_value) const {
  if (!hasPrinterResolutionSupported()) {
  return fallback_value;
}
return member_printer_resolution_supported_;
}

HeapVector<Member<WebPrintingResolution>> WebPrinterAttributes::getPrinterResolutionSupportedOr(HeapVector<Member<WebPrintingResolution>>&& fallback_value) const {
  if (!hasPrinterResolutionSupported()) {
  return std::move(fallback_value);
}
return member_printer_resolution_supported_;
}

void WebPrinterAttributes::setPrinterResolutionSupported(const HeapVector<Member<WebPrintingResolution>>& value) {
  member_printer_resolution_supported_ = value;
has_printer_resolution_supported_ = true;
}

void WebPrinterAttributes::setPrinterResolutionSupported(HeapVector<Member<WebPrintingResolution>>&& value) {
  member_printer_resolution_supported_ = std::move(value);
has_printer_resolution_supported_ = true;
}











String WebPrinterAttributes::getPrinterStateMessageOr(const String& fallback_value) const {
  if (!hasPrinterStateMessage()) {
  return fallback_value;
}
return member_printer_state_message_;
}

String WebPrinterAttributes::getPrinterStateMessageOr(String&& fallback_value) const {
  if (!hasPrinterStateMessage()) {
  return std::move(fallback_value);
}
return member_printer_state_message_;
}

void WebPrinterAttributes::setPrinterStateMessage(const String& value) {
  member_printer_state_message_ = value;
has_printer_state_message_ = true;
}

void WebPrinterAttributes::setPrinterStateMessage(String&& value) {
  member_printer_state_message_ = std::move(value);
has_printer_state_message_ = true;
}




Vector<V8WebPrinterStateReason> WebPrinterAttributes::getPrinterStateReasonsOr(const Vector<V8WebPrinterStateReason>& fallback_value) const {
  if (!hasPrinterStateReasons()) {
  return fallback_value;
}
return member_printer_state_reasons_;
}

Vector<V8WebPrinterStateReason> WebPrinterAttributes::getPrinterStateReasonsOr(Vector<V8WebPrinterStateReason>&& fallback_value) const {
  if (!hasPrinterStateReasons()) {
  return std::move(fallback_value);
}
return member_printer_state_reasons_;
}

void WebPrinterAttributes::setPrinterStateReasons(const Vector<V8WebPrinterStateReason>& value) {
  member_printer_state_reasons_ = value;
has_printer_state_reasons_ = true;
}

void WebPrinterAttributes::setPrinterStateReasons(Vector<V8WebPrinterStateReason>&& value) {
  member_printer_state_reasons_ = std::move(value);
has_printer_state_reasons_ = true;
}











Vector<V8WebPrintingSides> WebPrinterAttributes::getSidesSupportedOr(const Vector<V8WebPrintingSides>& fallback_value) const {
  if (!hasSidesSupported()) {
  return fallback_value;
}
return member_sides_supported_;
}

Vector<V8WebPrintingSides> WebPrinterAttributes::getSidesSupportedOr(Vector<V8WebPrintingSides>&& fallback_value) const {
  if (!hasSidesSupported()) {
  return std::move(fallback_value);
}
return member_sides_supported_;
}

void WebPrinterAttributes::setSidesSupported(const Vector<V8WebPrintingSides>& value) {
  member_sides_supported_ = value;
has_sides_supported_ = true;
}

void WebPrinterAttributes::setSidesSupported(Vector<V8WebPrintingSides>&& value) {
  member_sides_supported_ = std::move(value);
has_sides_supported_ = true;
}



void WebPrinterAttributes::Trace(Visitor* visitor) const {
  visitor->Trace(member_copies_supported_);
visitor->Trace(member_media_col_database_);
visitor->Trace(member_media_col_default_);
visitor->Trace(member_printer_resolution_default_);
visitor->Trace(member_printer_resolution_supported_);
bindings::DictionaryBase::Trace(visitor);
}

void WebPrinterAttributes::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void WebPrinterAttributes::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasCopiesDefault()) {
  values[0] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_copies_default_);
DCHECK(!values[0].IsEmpty());
}
if (hasCopiesSupported()) {
  values[1] = ToV8Traits<WebPrintingRange>::ToV8(script_state, member_copies_supported_.Get());
DCHECK(!values[1].IsEmpty());
}
if (hasDocumentFormatDefault()) {
  values[2] = ToV8Traits<V8WebPrintingMimeMediaType>::ToV8(script_state, member_document_format_default_);
DCHECK(!values[2].IsEmpty());
}
if (hasDocumentFormatSupported()) {
  values[3] = ToV8Traits<IDLSequence<V8WebPrintingMimeMediaType>>::ToV8(script_state, member_document_format_supported_);
DCHECK(!values[3].IsEmpty());
}
if (hasMediaColDatabase()) {
  values[4] = ToV8Traits<IDLSequence<WebPrintingMediaCollection>>::ToV8(script_state, member_media_col_database_);
DCHECK(!values[4].IsEmpty());
}
if (hasMediaColDefault()) {
  values[5] = ToV8Traits<WebPrintingMediaCollection>::ToV8(script_state, member_media_col_default_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasMediaSourceDefault()) {
  values[6] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_media_source_default_);
DCHECK(!values[6].IsEmpty());
}
if (hasMediaSourceSupported()) {
  values[7] = ToV8Traits<IDLSequence<IDLUSVString>>::ToV8(script_state, member_media_source_supported_);
DCHECK(!values[7].IsEmpty());
}
if (hasMultipleDocumentHandlingDefault()) {
  values[8] = ToV8Traits<V8WebPrintingMultipleDocumentHandling>::ToV8(script_state, member_multiple_document_handling_default_);
DCHECK(!values[8].IsEmpty());
}
if (hasMultipleDocumentHandlingSupported()) {
  values[9] = ToV8Traits<IDLSequence<V8WebPrintingMultipleDocumentHandling>>::ToV8(script_state, member_multiple_document_handling_supported_);
DCHECK(!values[9].IsEmpty());
}
if (hasOrientationRequestedDefault()) {
  values[10] = ToV8Traits<V8WebPrintingOrientationRequested>::ToV8(script_state, member_orientation_requested_default_);
DCHECK(!values[10].IsEmpty());
}
if (hasOrientationRequestedSupported()) {
  values[11] = ToV8Traits<IDLSequence<V8WebPrintingOrientationRequested>>::ToV8(script_state, member_orientation_requested_supported_);
DCHECK(!values[11].IsEmpty());
}
if (hasPrintColorModeDefault()) {
  values[12] = ToV8Traits<V8WebPrintColorMode>::ToV8(script_state, member_print_color_mode_default_);
DCHECK(!values[12].IsEmpty());
}
if (hasPrintColorModeSupported()) {
  values[13] = ToV8Traits<IDLSequence<V8WebPrintColorMode>>::ToV8(script_state, member_print_color_mode_supported_);
DCHECK(!values[13].IsEmpty());
}
if (hasPrintQualityDefault()) {
  values[14] = ToV8Traits<V8WebPrintQuality>::ToV8(script_state, member_print_quality_default_);
DCHECK(!values[14].IsEmpty());
}
if (hasPrintQualitySupported()) {
  values[15] = ToV8Traits<IDLSequence<V8WebPrintQuality>>::ToV8(script_state, member_print_quality_supported_);
DCHECK(!values[15].IsEmpty());
}
if (hasPrinterId()) {
  values[16] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_printer_id_);
DCHECK(!values[16].IsEmpty());
}
if (hasPrinterName()) {
  values[17] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_printer_name_);
DCHECK(!values[17].IsEmpty());
}
if (hasPrinterResolutionDefault()) {
  values[18] = ToV8Traits<WebPrintingResolution>::ToV8(script_state, member_printer_resolution_default_.Get());
DCHECK(!values[18].IsEmpty());
}
if (hasPrinterResolutionSupported()) {
  values[19] = ToV8Traits<IDLSequence<WebPrintingResolution>>::ToV8(script_state, member_printer_resolution_supported_);
DCHECK(!values[19].IsEmpty());
}
if (hasPrinterState()) {
  values[20] = ToV8Traits<V8WebPrinterState>::ToV8(script_state, member_printer_state_);
DCHECK(!values[20].IsEmpty());
}
if (hasPrinterStateMessage()) {
  values[21] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_printer_state_message_);
DCHECK(!values[21].IsEmpty());
}
if (hasPrinterStateReasons()) {
  values[22] = ToV8Traits<IDLSequence<V8WebPrinterStateReason>>::ToV8(script_state, member_printer_state_reasons_);
DCHECK(!values[22].IsEmpty());
}
if (hasSidesDefault()) {
  values[23] = ToV8Traits<V8WebPrintingSides>::ToV8(script_state, member_sides_default_);
DCHECK(!values[23].IsEmpty());
}
if (hasSidesSupported()) {
  values[24] = ToV8Traits<IDLSequence<V8WebPrintingSides>>::ToV8(script_state, member_sides_supported_);
DCHECK(!values[24].IsEmpty());
}
}

const void* WebPrinterAttributes::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> WebPrinterAttributes::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void WebPrinterAttributes::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WebPrinterAttributes";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("copiesDefault");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_copies_default_, member_copies_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("copiesSupported");
if (!bindings::GetDictionaryMemberFromV8Object<WebPrintingRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_copies_supported_, member_copies_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("documentFormatDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingMimeMediaType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_document_format_default_, member_document_format_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("documentFormatSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrintingMimeMediaType>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_document_format_supported_, member_document_format_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaColDatabase");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<WebPrintingMediaCollection>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_media_col_database_, member_media_col_database_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaColDefault");
if (!bindings::GetDictionaryMemberFromV8Object<WebPrintingMediaCollection, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_media_col_default_, member_media_col_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaSourceDefault");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_media_source_default_, member_media_source_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("mediaSourceSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLUSVString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_media_source_supported_, member_media_source_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("multipleDocumentHandlingDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingMultipleDocumentHandling, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_multiple_document_handling_default_, member_multiple_document_handling_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("multipleDocumentHandlingSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrintingMultipleDocumentHandling>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_multiple_document_handling_supported_, member_multiple_document_handling_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("orientationRequestedDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingOrientationRequested, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_orientation_requested_default_, member_orientation_requested_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("orientationRequestedSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrintingOrientationRequested>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_orientation_requested_supported_, member_orientation_requested_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printColorModeDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintColorMode, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_print_color_mode_default_, member_print_color_mode_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printColorModeSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrintColorMode>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_print_color_mode_supported_, member_print_color_mode_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printQualityDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintQuality, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_print_quality_default_, member_print_quality_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printQualitySupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrintQuality>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), has_print_quality_supported_, member_print_quality_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_printer_id_, member_printer_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerName");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_printer_name_, member_printer_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerResolutionDefault");
if (!bindings::GetDictionaryMemberFromV8Object<WebPrintingResolution, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_printer_resolution_default_, member_printer_resolution_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerResolutionSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<WebPrintingResolution>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_printer_resolution_supported_, member_printer_resolution_supported_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerState");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrinterState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), has_printer_state_, member_printer_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerStateMessage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_printer_state_message_, member_printer_state_message_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("printerStateReasons");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrinterStateReason>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), has_printer_state_reasons_, member_printer_state_reasons_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sidesDefault");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintingSides, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_sides_default_, member_sides_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("sidesSupported");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<V8WebPrintingSides>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[24].Get(isolate), has_sides_supported_, member_sides_supported_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> WebPrinterAttributes::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
