// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USER_MEDIA_STREAM_CONSTRAINTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USER_MEDIA_STREAM_CONSTRAINTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaTrackConstraints;
class V8UnionBooleanOrMediaTrackConstraints;

class MODULES_EXPORT UserMediaStreamConstraints : public bindings::InputDictionaryBase {
  
  public:
static UserMediaStreamConstraints* Create() {
  return MakeGarbageCollected<UserMediaStreamConstraints>();
}
static UserMediaStreamConstraints* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<UserMediaStreamConstraints>(isolate);
}
static UserMediaStreamConstraints* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  UserMediaStreamConstraints();
explicit  UserMediaStreamConstraints(v8::Isolate* isolate);

bool hasAudio() const {
  return true;
}
V8UnionBooleanOrMediaTrackConstraints* audio() const {
  return member_audio_.Get();
}
void setAudio(V8UnionBooleanOrMediaTrackConstraints* value) {
  member_audio_ = value;
DCHECK(member_audio_);
}

bool hasVideo() const {
  return true;
}
V8UnionBooleanOrMediaTrackConstraints* video() const {
  return member_video_.Get();
}
void setVideo(V8UnionBooleanOrMediaTrackConstraints* value) {
  member_video_ = value;
DCHECK(member_video_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



Member<V8UnionBooleanOrMediaTrackConstraints> member_audio_;
Member<V8UnionBooleanOrMediaTrackConstraints> member_video_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USER_MEDIA_STREAM_CONSTRAINTS_H_
