// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ROUTERSOURCE_ROUTERSOURCEENUM_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ROUTERSOURCE_ROUTERSOURCEENUM_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_router_source_enum.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class RouterSource;
class ScriptState;

class MODULES_EXPORT V8UnionRouterSourceOrRouterSourceEnum final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kRouterSource, kRouterSourceEnum
};

static V8UnionRouterSourceOrRouterSourceEnum* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionRouterSourceOrRouterSourceEnum(RouterSource* value) : content_type_(ContentType::kRouterSource), member_router_source_(value) {
  DCHECK(value);
}
explicit  V8UnionRouterSourceOrRouterSourceEnum(V8RouterSourceEnum value) : content_type_(ContentType::kRouterSourceEnum), member_router_source_enum_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsRouterSource() const {
  return content_type_ == ContentType::kRouterSource;
}
RouterSource* GetAsRouterSource() const {
  DCHECK_EQ(content_type_, ContentType::kRouterSource);
return member_router_source_.Get();
}
void Set(RouterSource* value) {
  DCHECK(value);
Clear();
member_router_source_ = value;
content_type_ = ContentType::kRouterSource;
}

bool IsRouterSourceEnum() const {
  return content_type_ == ContentType::kRouterSourceEnum;
}
V8RouterSourceEnum GetAsRouterSourceEnum() const {
  DCHECK_EQ(content_type_, ContentType::kRouterSourceEnum);
return member_router_source_enum_;
}
void Set(V8RouterSourceEnum value) {
  Clear();
member_router_source_enum_ = value;
content_type_ = ContentType::kRouterSourceEnum;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(RouterSource or RouterSourceEnum)";
}

ContentType content_type_;

Member<RouterSource> member_router_source_;
V8RouterSourceEnum member_router_source_enum_{static_cast<V8RouterSourceEnum::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ROUTERSOURCE_ROUTERSOURCEENUM_H_
