// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_LANGUAGE_MODEL_PROMPT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_LANGUAGE_MODEL_PROMPT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class LanguageModelMessage;
class ScriptState;

class MODULES_EXPORT V8LanguageModelPrompt final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kLanguageModelMessageSequence, kString
};

static V8LanguageModelPrompt* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8LanguageModelPrompt(const HeapVector<Member<LanguageModelMessage>>& value);
explicit  V8LanguageModelPrompt(HeapVector<Member<LanguageModelMessage>>&& value);
explicit  V8LanguageModelPrompt(const String& value);
explicit  V8LanguageModelPrompt(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsLanguageModelMessageSequence() const {
  return content_type_ == ContentType::kLanguageModelMessageSequence;
}
const HeapVector<Member<LanguageModelMessage>>& GetAsLanguageModelMessageSequence() const {
  DCHECK_EQ(content_type_, ContentType::kLanguageModelMessageSequence);
return member_language_model_message_sequence_;
}
void Set(const HeapVector<Member<LanguageModelMessage>>& value);
void Set(HeapVector<Member<LanguageModelMessage>>&& value);

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(DOMString or sequence<LanguageModelMessage>)";
}

ContentType content_type_;

HeapVector<Member<LanguageModelMessage>> member_language_model_message_sequence_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_LANGUAGE_MODEL_PROMPT_H_
