// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_language_model_message_value.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_audio_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_canvas_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_video_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_svg_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_blob_string.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_htmlcanvaselement_offscreencanvas.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_audio_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_blob_htmlcanvaselement_htmlimageelement_htmlvideoelement_imagebitmap_imagedata_offscreencanvas_svgimageelement_videoframe.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_htmlcanvaselement_htmlimageelement_htmlvideoelement_imagebitmap_imagedata_offscreencanvas_videoframe.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_htmlvideoelement_videoframe.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/core/html/canvas/html_canvas_element.h"
#include "third_party/blink/renderer/core/html/canvas/image_data.h"
#include "third_party/blink/renderer/core/html/html_image_element.h"
#include "third_party/blink/renderer/core/html/media/html_audio_element.h"
#include "third_party/blink/renderer/core/html/media/html_video_element.h"
#include "third_party/blink/renderer/core/imagebitmap/image_bitmap.h"
#include "third_party/blink/renderer/core/offscreencanvas/offscreen_canvas.h"
#include "third_party/blink/renderer/core/svg/svg_image_element.h"
#include "third_party/blink/renderer/modules/webaudio/audio_buffer.h"
#include "third_party/blink/renderer/modules/webcodecs/video_frame.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8LanguageModelMessageValue* V8LanguageModelMessageValue::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8SVGImageElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8SVGImageElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8HTMLVideoElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLVideoElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8HTMLAudioElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLAudioElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8HTMLImageElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLImageElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8HTMLCanvasElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLCanvasElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8OffscreenCanvas::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8OffscreenCanvas::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8VideoFrame::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8VideoFrame::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8ImageData::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ImageData::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8ImageBitmap::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ImageBitmap::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8Blob::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Blob::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (V8AudioBuffer::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8AudioBuffer::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
if (v8_value->IsArrayBufferView()) {
  auto&& blink_value = NativeValueTraits<NotShared<DOMArrayBufferView>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8LanguageModelMessageValue>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8LanguageModelMessageValue>(std::move(blink_value));
}
}

 V8LanguageModelMessageValue::V8LanguageModelMessageValue(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8LanguageModelMessageValue::V8LanguageModelMessageValue(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}








































void V8LanguageModelMessageValue::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8LanguageModelMessageValue::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}





V8UnionArrayBufferOrArrayBufferView* V8LanguageModelMessageValue::GetAsV8UnionArrayBufferOrArrayBufferView() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferView>(GetAsArrayBufferView());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionArrayBufferOrArrayBufferView* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferView::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
}
}






V8UnionArrayBufferOrArrayBufferViewOrString* V8LanguageModelMessageValue::GetAsV8UnionArrayBufferOrArrayBufferViewOrString() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrString>(GetAsArrayBuffer());
  }
  case ContentType::kArrayBufferView: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrString>(GetAsArrayBufferView());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionArrayBufferOrArrayBufferViewOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionArrayBufferOrArrayBufferViewOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrArrayBufferViewOrString::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrString::ContentType::kArrayBufferView: {
    Set(value->GetAsArrayBufferView());
    break;
  }
  case V8UnionArrayBufferOrArrayBufferViewOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionArrayBufferOrString* V8LanguageModelMessageValue::GetAsV8UnionArrayBufferOrString() const {
  switch (content_type_) {
  case ContentType::kArrayBuffer: {
    return MakeGarbageCollected<V8UnionArrayBufferOrString>(GetAsArrayBuffer());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionArrayBufferOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionArrayBufferOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionArrayBufferOrString::ContentType::kArrayBuffer: {
    Set(value->GetAsArrayBuffer());
    break;
  }
  case V8UnionArrayBufferOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame* V8LanguageModelMessageValue::GetAsV8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame() const {
  switch (content_type_) {
  case ContentType::kBlob: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsBlob());
  }
  case ContentType::kHTMLCanvasElement: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsHTMLCanvasElement());
  }
  case ContentType::kHTMLImageElement: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsHTMLImageElement());
  }
  case ContentType::kHTMLVideoElement: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsHTMLVideoElement());
  }
  case ContentType::kImageBitmap: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsImageBitmap());
  }
  case ContentType::kImageData: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsImageData());
  }
  case ContentType::kOffscreenCanvas: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsOffscreenCanvas());
  }
  case ContentType::kSVGImageElement: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsSVGImageElement());
  }
  case ContentType::kVideoFrame: {
    return MakeGarbageCollected<V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame>(GetAsVideoFrame());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame* value) {
  switch (value->GetContentType()) {
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kBlob: {
    Set(value->GetAsBlob());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kHTMLCanvasElement: {
    Set(value->GetAsHTMLCanvasElement());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kHTMLImageElement: {
    Set(value->GetAsHTMLImageElement());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kHTMLVideoElement: {
    Set(value->GetAsHTMLVideoElement());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kImageBitmap: {
    Set(value->GetAsImageBitmap());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kImageData: {
    Set(value->GetAsImageData());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kOffscreenCanvas: {
    Set(value->GetAsOffscreenCanvas());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kSVGImageElement: {
    Set(value->GetAsSVGImageElement());
    break;
  }
  case V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame::ContentType::kVideoFrame: {
    Set(value->GetAsVideoFrame());
    break;
  }
}
}




V8UnionBlobOrString* V8LanguageModelMessageValue::GetAsV8UnionBlobOrString() const {
  switch (content_type_) {
  case ContentType::kBlob: {
    return MakeGarbageCollected<V8UnionBlobOrString>(GetAsBlob());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionBlobOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionBlobOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionBlobOrString::ContentType::kBlob: {
    Set(value->GetAsBlob());
    break;
  }
  case V8UnionBlobOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* V8LanguageModelMessageValue::GetAsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame() const {
  switch (content_type_) {
  case ContentType::kHTMLCanvasElement: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsHTMLCanvasElement());
  }
  case ContentType::kHTMLImageElement: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsHTMLImageElement());
  }
  case ContentType::kHTMLVideoElement: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsHTMLVideoElement());
  }
  case ContentType::kImageBitmap: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsImageBitmap());
  }
  case ContentType::kImageData: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsImageData());
  }
  case ContentType::kOffscreenCanvas: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsOffscreenCanvas());
  }
  case ContentType::kVideoFrame: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame>(GetAsVideoFrame());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* value) {
  switch (value->GetContentType()) {
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kHTMLCanvasElement: {
    Set(value->GetAsHTMLCanvasElement());
    break;
  }
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kHTMLImageElement: {
    Set(value->GetAsHTMLImageElement());
    break;
  }
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kHTMLVideoElement: {
    Set(value->GetAsHTMLVideoElement());
    break;
  }
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kImageBitmap: {
    Set(value->GetAsImageBitmap());
    break;
  }
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kImageData: {
    Set(value->GetAsImageData());
    break;
  }
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kOffscreenCanvas: {
    Set(value->GetAsOffscreenCanvas());
    break;
  }
  case V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame::ContentType::kVideoFrame: {
    Set(value->GetAsVideoFrame());
    break;
  }
}
}




V8UnionHTMLCanvasElementOrOffscreenCanvas* V8LanguageModelMessageValue::GetAsV8UnionHTMLCanvasElementOrOffscreenCanvas() const {
  switch (content_type_) {
  case ContentType::kHTMLCanvasElement: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrOffscreenCanvas>(GetAsHTMLCanvasElement());
  }
  case ContentType::kOffscreenCanvas: {
    return MakeGarbageCollected<V8UnionHTMLCanvasElementOrOffscreenCanvas>(GetAsOffscreenCanvas());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionHTMLCanvasElementOrOffscreenCanvas* value) {
  switch (value->GetContentType()) {
  case V8UnionHTMLCanvasElementOrOffscreenCanvas::ContentType::kHTMLCanvasElement: {
    Set(value->GetAsHTMLCanvasElement());
    break;
  }
  case V8UnionHTMLCanvasElementOrOffscreenCanvas::ContentType::kOffscreenCanvas: {
    Set(value->GetAsOffscreenCanvas());
    break;
  }
}
}


V8UnionHTMLVideoElementOrVideoFrame* V8LanguageModelMessageValue::GetAsV8UnionHTMLVideoElementOrVideoFrame() const {
  switch (content_type_) {
  case ContentType::kHTMLVideoElement: {
    return MakeGarbageCollected<V8UnionHTMLVideoElementOrVideoFrame>(GetAsHTMLVideoElement());
  }
  case ContentType::kVideoFrame: {
    return MakeGarbageCollected<V8UnionHTMLVideoElementOrVideoFrame>(GetAsVideoFrame());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8LanguageModelMessageValue::Set(const V8UnionHTMLVideoElementOrVideoFrame* value) {
  switch (value->GetContentType()) {
  case V8UnionHTMLVideoElementOrVideoFrame::ContentType::kHTMLVideoElement: {
    Set(value->GetAsHTMLVideoElement());
    break;
  }
  case V8UnionHTMLVideoElementOrVideoFrame::ContentType::kVideoFrame: {
    Set(value->GetAsVideoFrame());
    break;
  }
}
}


void V8LanguageModelMessageValue::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_);
visitor->Trace(member_array_buffer_view_);
visitor->Trace(member_audio_buffer_);
visitor->Trace(member_blob_);
visitor->Trace(member_html_audio_element_);
visitor->Trace(member_html_canvas_element_);
visitor->Trace(member_html_image_element_);
visitor->Trace(member_html_video_element_);
visitor->Trace(member_image_bitmap_);
visitor->Trace(member_image_data_);
visitor->Trace(member_offscreen_canvas_);
visitor->Trace(member_svg_image_element_);
visitor->Trace(member_video_frame_);
bindings::UnionBase::Trace(visitor);
}

void V8LanguageModelMessageValue::Clear() {
  member_array_buffer_.Clear();
member_array_buffer_view_.Clear();
member_audio_buffer_.Clear();
member_blob_.Clear();
member_html_audio_element_.Clear();
member_html_canvas_element_.Clear();
member_html_image_element_.Clear();
member_html_video_element_.Clear();
member_image_bitmap_.Clear();
member_image_data_.Clear();
member_offscreen_canvas_.Clear();
member_svg_image_element_.Clear();
member_string_ = String();
member_video_frame_.Clear();
}



}  // namespace blink
