// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_IDBINDEX_IDBOBJECTSTORE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_IDBINDEX_IDBOBJECTSTORE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class IDBIndex;
class IDBObjectStore;
class ScriptState;

class MODULES_EXPORT V8UnionIDBIndexOrIDBObjectStore final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kIDBIndex, kIDBObjectStore
};

static V8UnionIDBIndexOrIDBObjectStore* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionIDBIndexOrIDBObjectStore(IDBIndex* value) : content_type_(ContentType::kIDBIndex), member_idb_index_(value) {
  DCHECK(value);
}
explicit  V8UnionIDBIndexOrIDBObjectStore(IDBObjectStore* value) : content_type_(ContentType::kIDBObjectStore), member_idb_object_store_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsIDBIndex() const {
  return content_type_ == ContentType::kIDBIndex;
}
IDBIndex* GetAsIDBIndex() const {
  DCHECK_EQ(content_type_, ContentType::kIDBIndex);
return member_idb_index_.Get();
}
void Set(IDBIndex* value) {
  DCHECK(value);
Clear();
member_idb_index_ = value;
content_type_ = ContentType::kIDBIndex;
}

bool IsIDBObjectStore() const {
  return content_type_ == ContentType::kIDBObjectStore;
}
IDBObjectStore* GetAsIDBObjectStore() const {
  DCHECK_EQ(content_type_, ContentType::kIDBObjectStore);
return member_idb_object_store_.Get();
}
void Set(IDBObjectStore* value) {
  DCHECK(value);
Clear();
member_idb_object_store_ = value;
content_type_ = ContentType::kIDBObjectStore;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(IDBIndex or IDBObjectStore)";
}

ContentType content_type_;

Member<IDBIndex> member_idb_index_;
Member<IDBObjectStore> member_idb_object_store_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_IDBINDEX_IDBOBJECTSTORE_H_
