// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_idbcursor_idbindex_idbobjectstore.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_cursor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_index.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_idb_object_store.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_idbindex_idbobjectstore.h"
#include "third_party/blink/renderer/modules/indexeddb/idb_cursor.h"
#include "third_party/blink/renderer/modules/indexeddb/idb_index.h"
#include "third_party/blink/renderer/modules/indexeddb/idb_object_store.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionIDBCursorOrIDBIndexOrIDBObjectStore* V8UnionIDBCursorOrIDBIndexOrIDBObjectStore::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8IDBObjectStore::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8IDBObjectStore::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionIDBCursorOrIDBIndexOrIDBObjectStore>(blink_value);
}
if (V8IDBIndex::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8IDBIndex::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionIDBCursorOrIDBIndexOrIDBObjectStore>(blink_value);
}
if (V8IDBCursor::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8IDBCursor::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionIDBCursorOrIDBIndexOrIDBObjectStore>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













V8UnionIDBIndexOrIDBObjectStore* V8UnionIDBCursorOrIDBIndexOrIDBObjectStore::GetAsV8UnionIDBIndexOrIDBObjectStore() const {
  switch (content_type_) {
  case ContentType::kIDBIndex: {
    return MakeGarbageCollected<V8UnionIDBIndexOrIDBObjectStore>(GetAsIDBIndex());
  }
  case ContentType::kIDBObjectStore: {
    return MakeGarbageCollected<V8UnionIDBIndexOrIDBObjectStore>(GetAsIDBObjectStore());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionIDBCursorOrIDBIndexOrIDBObjectStore::Set(const V8UnionIDBIndexOrIDBObjectStore* value) {
  switch (value->GetContentType()) {
  case V8UnionIDBIndexOrIDBObjectStore::ContentType::kIDBIndex: {
    Set(value->GetAsIDBIndex());
    break;
  }
  case V8UnionIDBIndexOrIDBObjectStore::ContentType::kIDBObjectStore: {
    Set(value->GetAsIDBObjectStore());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionIDBCursorOrIDBIndexOrIDBObjectStore::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kIDBCursor: {
    return ToV8Traits<IDBCursor>::ToV8(script_state, member_idb_cursor_.Get());
  }
  case ContentType::kIDBIndex: {
    return ToV8Traits<IDBIndex>::ToV8(script_state, member_idb_index_.Get());
  }
  case ContentType::kIDBObjectStore: {
    return ToV8Traits<IDBObjectStore>::ToV8(script_state, member_idb_object_store_.Get());
  }
}

NOTREACHED();
}

void V8UnionIDBCursorOrIDBIndexOrIDBObjectStore::Trace(Visitor* visitor) const {
  visitor->Trace(member_idb_cursor_);
visitor->Trace(member_idb_index_);
visitor->Trace(member_idb_object_store_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionIDBCursorOrIDBIndexOrIDBObjectStore::Clear() {
  member_idb_cursor_.Clear();
member_idb_index_.Clear();
member_idb_object_store_.Clear();
}



}  // namespace blink
