// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINPOINT_2_DPARAMETERS_POINT_2_DSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINPOINT_2_DPARAMETERS_POINT_2_DSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ConstrainPoint2DParameters;
class ExceptionState;
class Point2D;
class ScriptState;

class MODULES_EXPORT V8UnionConstrainPoint2DParametersOrPoint2DSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kConstrainPoint2DParameters, kPoint2DSequence
};

static V8UnionConstrainPoint2DParametersOrPoint2DSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionConstrainPoint2DParametersOrPoint2DSequence(ConstrainPoint2DParameters* value) : content_type_(ContentType::kConstrainPoint2DParameters), member_constrain_point_2d_parameters_(value) {
  DCHECK(value);
}
explicit  V8UnionConstrainPoint2DParametersOrPoint2DSequence(const HeapVector<Member<Point2D>>& value);
explicit  V8UnionConstrainPoint2DParametersOrPoint2DSequence(HeapVector<Member<Point2D>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsConstrainPoint2DParameters() const {
  return content_type_ == ContentType::kConstrainPoint2DParameters;
}
ConstrainPoint2DParameters* GetAsConstrainPoint2DParameters() const {
  DCHECK_EQ(content_type_, ContentType::kConstrainPoint2DParameters);
return member_constrain_point_2d_parameters_.Get();
}
void Set(ConstrainPoint2DParameters* value) {
  DCHECK(value);
Clear();
member_constrain_point_2d_parameters_ = value;
content_type_ = ContentType::kConstrainPoint2DParameters;
}

bool IsPoint2DSequence() const {
  return content_type_ == ContentType::kPoint2DSequence;
}
const HeapVector<Member<Point2D>>& GetAsPoint2DSequence() const {
  DCHECK_EQ(content_type_, ContentType::kPoint2DSequence);
return member_point_2d_sequence_;
}
void Set(const HeapVector<Member<Point2D>>& value);
void Set(HeapVector<Member<Point2D>>&& value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ConstrainPoint2DParameters or sequence<Point2D>)";
}

ContentType content_type_;

Member<ConstrainPoint2DParameters> member_constrain_point_2d_parameters_;
HeapVector<Member<Point2D>> member_point_2d_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CONSTRAINPOINT_2_DPARAMETERS_POINT_2_DSEQUENCE_H_
