// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CLIENT_MESSAGEPORT_SERVICEWORKER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CLIENT_MESSAGEPORT_SERVICEWORKER_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MessagePort;
class ScriptState;
class ServiceWorker;
class ServiceWorkerClient;

class MODULES_EXPORT V8UnionClientOrMessagePortOrServiceWorker final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kClient, kMessagePort, kServiceWorker
};

static V8UnionClientOrMessagePortOrServiceWorker* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionClientOrMessagePortOrServiceWorker(ServiceWorkerClient* value) : content_type_(ContentType::kClient), member_client_(value) {
  DCHECK(value);
}
explicit  V8UnionClientOrMessagePortOrServiceWorker(MessagePort* value) : content_type_(ContentType::kMessagePort), member_message_port_(value) {
  DCHECK(value);
}
explicit  V8UnionClientOrMessagePortOrServiceWorker(ServiceWorker* value) : content_type_(ContentType::kServiceWorker), member_service_worker_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsClient() const {
  return content_type_ == ContentType::kClient;
}
ServiceWorkerClient* GetAsClient() const {
  DCHECK_EQ(content_type_, ContentType::kClient);
return member_client_.Get();
}
void Set(ServiceWorkerClient* value) {
  DCHECK(value);
Clear();
member_client_ = value;
content_type_ = ContentType::kClient;
}

bool IsMessagePort() const {
  return content_type_ == ContentType::kMessagePort;
}
MessagePort* GetAsMessagePort() const {
  DCHECK_EQ(content_type_, ContentType::kMessagePort);
return member_message_port_.Get();
}
void Set(MessagePort* value) {
  DCHECK(value);
Clear();
member_message_port_ = value;
content_type_ = ContentType::kMessagePort;
}

bool IsServiceWorker() const {
  return content_type_ == ContentType::kServiceWorker;
}
ServiceWorker* GetAsServiceWorker() const {
  DCHECK_EQ(content_type_, ContentType::kServiceWorker);
return member_service_worker_.Get();
}
void Set(ServiceWorker* value) {
  DCHECK(value);
Clear();
member_service_worker_ = value;
content_type_ = ContentType::kServiceWorker;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Client or MessagePort or ServiceWorker)";
}

ContentType content_type_;

Member<ServiceWorkerClient> member_client_;
Member<MessagePort> member_message_port_;
Member<ServiceWorker> member_service_worker_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_CLIENT_MESSAGEPORT_SERVICEWORKER_H_
