// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BOOLEAN_CONSTRAINBOOLEANORDOMSTRINGPARAMETERS_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BOOLEAN_CONSTRAINBOOLEANORDOMSTRINGPARAMETERS_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ConstrainBooleanOrDOMStringParameters;
class ExceptionState;
class ScriptState;
class V8UnionBooleanOrString;

class MODULES_EXPORT V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kBoolean, kConstrainBooleanOrDOMStringParameters, kString
};

static V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString(bool value) : content_type_(ContentType::kBoolean), member_boolean_(value) {
  
}
explicit  V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString(ConstrainBooleanOrDOMStringParameters* value) : content_type_(ContentType::kConstrainBooleanOrDOMStringParameters), member_constrain_boolean_or_dom_string_parameters_(value) {
  DCHECK(value);
}
explicit  V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString(const String& value);
explicit  V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsBoolean() const {
  return content_type_ == ContentType::kBoolean;
}
bool GetAsBoolean() const {
  DCHECK_EQ(content_type_, ContentType::kBoolean);
return member_boolean_;
}
void Set(bool value) {
  Clear();
member_boolean_ = value;
content_type_ = ContentType::kBoolean;
}

bool IsConstrainBooleanOrDOMStringParameters() const {
  return content_type_ == ContentType::kConstrainBooleanOrDOMStringParameters;
}
ConstrainBooleanOrDOMStringParameters* GetAsConstrainBooleanOrDOMStringParameters() const {
  DCHECK_EQ(content_type_, ContentType::kConstrainBooleanOrDOMStringParameters);
return member_constrain_boolean_or_dom_string_parameters_.Get();
}
void Set(ConstrainBooleanOrDOMStringParameters* value) {
  DCHECK(value);
Clear();
member_constrain_boolean_or_dom_string_parameters_ = value;
content_type_ = ContentType::kConstrainBooleanOrDOMStringParameters;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsV8UnionBooleanOrString() const {
  return content_type_ == ContentType::kBoolean || content_type_ == ContentType::kString;
}
V8UnionBooleanOrString* GetAsV8UnionBooleanOrString() const;
void Set(const V8UnionBooleanOrString* value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ConstrainBooleanOrDOMStringParameters or DOMString or boolean)";
}

ContentType content_type_;

bool member_boolean_;
Member<ConstrainBooleanOrDOMStringParameters> member_constrain_boolean_or_dom_string_parameters_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BOOLEAN_CONSTRAINBOOLEANORDOMSTRINGPARAMETERS_STRING_H_
