// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_SYNTHESIS_ERROR_EVENT_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_SYNTHESIS_ERROR_EVENT_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_speech_synthesis_error_code.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_speech_synthesis_event_init.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SpeechSynthesisErrorEventInit : public SpeechSynthesisEventInit {
  
  public:
static SpeechSynthesisErrorEventInit* Create() {
  return MakeGarbageCollected<SpeechSynthesisErrorEventInit>();
}
static SpeechSynthesisErrorEventInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SpeechSynthesisErrorEventInit>(isolate);
}
static SpeechSynthesisErrorEventInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SpeechSynthesisErrorEventInit();
explicit  SpeechSynthesisErrorEventInit(v8::Isolate* isolate);

bool hasError() const {
  return true;
}
V8SpeechSynthesisErrorCode error() const {
  return member_error_;
}
void setError(V8SpeechSynthesisErrorCode value) {
  member_error_ = value;
}
void setError(V8SpeechSynthesisErrorCode::Enum value) {
  member_error_ = V8SpeechSynthesisErrorCode(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = SpeechSynthesisEventInit::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8SpeechSynthesisErrorCode member_error_{static_cast<V8SpeechSynthesisErrorCode::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SPEECH_SYNTHESIS_ERROR_EVENT_INIT_H_
