// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_GET_STATUS_CHANGE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_GET_STATUS_CHANGE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AbortSignal;
class ExceptionState;

class MODULES_EXPORT SmartCardGetStatusChangeOptions : public bindings::InputDictionaryBase {
  
  public:
static SmartCardGetStatusChangeOptions* Create() {
  return MakeGarbageCollected<SmartCardGetStatusChangeOptions>();
}
static SmartCardGetStatusChangeOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SmartCardGetStatusChangeOptions>(isolate);
}
static SmartCardGetStatusChangeOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SmartCardGetStatusChangeOptions();
explicit  SmartCardGetStatusChangeOptions(v8::Isolate* isolate);

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}

bool hasTimeout() const {
  return has_timeout_;
}
double timeout() const {
  DCHECK(hasTimeout());
return member_timeout_;
}
double getTimeoutOr(double fallback_value) const {
  if (!hasTimeout()) {
  return fallback_value;
}
return member_timeout_;
}
void setTimeout(double value) {
  member_timeout_ = value;
has_timeout_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_signal_ = false;
bool has_timeout_ = false;

Member<AbortSignal> member_signal_;
double member_timeout_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SMART_CARD_GET_STATUS_CHANGE_OPTIONS_H_
